/** 
 * @file    kSvHealthOut.h
 * @brief   Declares the kSvHealthOut class and related types. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYC_SERVER_HEALTH_OUT_H
#define K_FIRESYC_SERVER_HEALTH_OUT_H

#include <kFireSync/Server/kSvDef.h>

/**
 * @internal
 * @class   kSvHealthOut
 * @extends kObject
 * @ingroup kFireSync-Server-Network
 * @brief   Represents the health output service.
 */
//typedef kObject kSvHealthOut;      --forward-declared in kFsDef.x.h
 
/** 
 * Constructs a kSvHealthOut object.
 *
 * @public              @memberof kSvHealthOut
 * @param   service     Destination for the constructed object handle. 
 * @param   node        Parent/owner.  
 * @param   allocator   Memory allocator (or kNULL for default). 
 * @return              Operation status. 
 */
kFsFx(kStatus) kSvHealthOut_Construct(kSvHealthOut* service, kSvNode node, kAlloc allocator);

kFsFx(kStatus) kSvHealthOut_SetLocalEndPoint(kSvHealthOut service, kIpAddress address, k32u port);
kFsFx(kIpEndPoint) kSvHealthOut_LocalEndPoint(kSvHealthOut service);

kFsFx(kStatus) kSvHealthOut_SetLogPeriod(kSvHealthOut service, k64u period);
kFsFx(k64u) kSvHealthOut_LogPeriod(kSvHealthOut service);

kFsFx(kStatus) kSvHealthOut_StartService(kSvHealthOut service);
kFsFx(kStatus) kSvHealthOut_StopService(kSvHealthOut service);

kFsFx(kStatus) kSvHealthOut_AddAppChannel(kSvHealthOut service, kCallbackFx function, kPointer receiver, kSvHealthOutApp* appChannel);
kFsFx(kStatus) kSvHealthOut_RemoveAppChannel(kSvHealthOut service, kSvHealthOutApp appChannel);

kFsFx(kStatus) kSvHealthOut_ReadHealthLog(kSvHealthOut service, kHealthSummary* summary, kAlloc alloc);
kFsFx(kStatus) kSvHealthOut_ClearHealthLog(kSvHealthOut service);

#include <kFireSync/Server/Network/kSvHealthOut.x.h>

#endif
