/** 
 * @file    kSvDiscovery.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYC_SERVER_DISCOVERY_X_H
#define K_FIRESYC_SERVER_DISCOVERY_X_H

#define kSV_DISCOVERY_CLIENT_WRITE_BUFFER           (1536)
#define kSV_DISCOVERY_SEND_PERIOD                   (300000)
#define kSV_DISCOVERY_SEND_TIMEOUT                  (100000)
#define kSV_DISCOVERY_ADDRESS_UPDATE_PERIOD         (5000000)


/* 
 * kSvDiscoveryAddress
 */
typedef struct kSvDiscoveryAddress
{
    kIpAddress address;
    kSize interfaceIndex;
} kSvDiscoveryAddress;

kDeclareValueEx(kFs, kSvDiscoveryAddress, kValue)

kFsFx(kBool) xkSvDiscoveryAddress_VEquals(kType type, const void* value, const void* other); 


/* 
 * kSvDiscovery
 */
typedef struct kSvDiscoveryClass
{
    kObjectClass base; 
    kSvNode node;                                   //Parent/owner.

    k32u remotePort;                                //Remote destination port for broadcasts. 

    kSvDiscoveryUpdateProviderFx updateCallback;    //Callback function to get lastest discovery information.   
    kPointer updateReceiver;                        //Callback receiver.

    kDiscoveryInfo localInfo;                       //Information about local node. 
    kLock localInfoLock;                            //Provides exclusive access to local info structure. 

    kPeriodic periodic;                             //Periodic background timer to dispatch updates.

    k64u updateCycleCount;                          //How many update-broadcasts periods have occurred?
    k64u addressUpdatePeriod;                       //Interval, in address update cycles, at which to check for IP address changes.

    kArrayList nextAddressList;                     //Latest list of addresses on which we should next bind -- kArrayList<kSvDiscoveryAddress>
    kArrayList addressList;                         //Actual list of addresses on which we are currently bound -- kArrayList<kSvDiscoveryAddress> 
    kArrayList clientList;                          //List of UDP clients corresponding to local addresses -- kArrayList<kUdpClient>
    kArrayList writerList;                          //List of serializers corresponding to UDP clients -- kArrayList<kSerializer>
           
} kSvDiscoveryClass; 

kDeclareClassEx(kFs, kSvDiscovery, kObject)
        
kFsFx(kStatus) kSvDiscovery_Init(kSvDiscovery discovery, kType type, kSvNode node, kAlloc alloc);
kFsFx(kStatus) kSvDiscovery_VRelease(kSvDiscovery discovery);

kFsFx(kStatus) kSvDiscovery_UpdateNextAddresses(kSvDiscovery discovery);
kFsFx(kBool) kSvDiscovery_HasLocalAddressChange(kSvDiscovery discovery); 

kFsFx(kStatus) kSvDiscovery_UpdateClients(kSvDiscovery discovery); 

kFsFx(kStatus) kSvDiscovery_OnPeriodicTimer(kSvDiscovery discovery, kPeriodic timer); 

kFsFx(kStatus) kSvDiscovery_SendUpdates(kSvDiscovery discovery);

#endif
