/** 
 * @file    kSvDataOutChannel.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYC_SERVER_DATA_OUT_CHANNEL_X_H
#define K_FIRESYC_SERVER_DATA_OUT_CHANNEL_X_H

typedef struct kSvDataOutChannelClass
{
    kObjectClass base; 
    kSvDataOut service;             //Parent. 

} kSvDataOutChannelClass; 

typedef struct kSvDataOutChannelVTable
{
    kObjectVTable base; 
        
    kStatus (kCall* VSend)(kSvDataOutChannel channel, kMsgInfo message); 
    kStatus (kCall* VEndSession)(kSvDataOutChannel channel); 
    kStatus (kCall* VCheckActivity)(kSvDataOutChannel channel); 
    kBool (kCall* VIsActive)(kSvDataOutChannel channel); 
    kStatus (kCall* VSetMaxQueueSize)(kSvDataOutChannel channel, kSize size);
    kStatus (kCall* VSetMaxQueueCount)(kSvDataOutChannel channel, kSize count);
    kStatus (kCall* VSetThreadPriority)(kSvDataOutChannel channel, kThreadPriorityClass priorityClass, k32s priorityOffset);
    kStatus (kCall* VSetThreadAffinity)(kSvDataOutChannel channel, kBitArray affinity);
} kSvDataOutChannelVTable; 

kDeclareVirtualClassEx(kFs, kSvDataOutChannel, kObject)
        
kFsFx(kStatus) kSvDataOutChannel_Init(kSvDataOutChannel channel, kType type, kSvDataOut service, kAlloc alloc);
kFsFx(kStatus) kSvDataOutChannel_VRelease(kSvDataOutChannel channel);

kFsFx(kStatus) kSvDataOutChannel_VSetMaxQueueSize(kSvDataOutChannel channel, kSize size);
kFsFx(kStatus) kSvDataOutChannel_VSetMaxQueueCount(kSvDataOutChannel channel, kSize count);
kFsFx(kStatus) kSvDataOutChannel_VSend(kSvDataOutChannel channel, kMsgInfo message);
kFsFx(kStatus) kSvDataOutChannel_VEndSession(kSvDataOutChannel channel);
kFsFx(kStatus) kSvDataOutChannel_VCheckActivity(kSvDataOutChannel channel);
kFsFx(kBool) kSvDataOutChannel_VIsActive(kSvDataOutChannel channel);
kFsFx(kStatus) kSvDataOutChannel_VSetThreadPriority(kSvDataOutChannel channel, kThreadPriorityClass priorityClass, k32s priorityOffset);
kFsFx(kStatus) kSvDataOutChannel_VSetThreadAffinity(kSvDataOutChannel channel, kBitArray affinity);

#endif
