/** 
 * @file    kSvDataInChannel.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYC_SERVER_DATA_IN_CHANNEL_X_H
#define K_FIRESYC_SERVER_DATA_IN_CHANNEL_X_H

#define kSV_DATA_IN_SOCKET_WRITE_BUFFER         (4096)                ///< Irrelevant to performance

#define kSV_DATA_IN_CONNECT_TIMEOUT             (1000000)             ///< Connection timeout (microseconds). 

#define kSV_DATA_IN_CONFIGURATION_TIMEOUT       (100000)              ///< Time to wait for reply to configuration message

typedef struct kSvDataInChannelEntry
{
    k16u sourcePortId;                  //Remote port id. 
    kPxPort destPort;                   //Local port object. 
} kSvDataInChannelEntry; 

kDeclareValueEx(kFs, kSvDataInChannelEntry, kValue)

typedef struct kSvDataInChannelClass
{
    kObjectClass base; 

    kSvDataIn service;                  //Parent. 
    k32u sourceNode;                    //Remote node identifier. 
    kIpEndPoint sourceEndPoint;         //Remote IP end point. 
    kAlloc messageAlloc;                //Message allocator. 
    kSize socketBufferSize;             //Per-channel socket read buffer size.

    kArrayList ports;                   //List of remote ports to be connected -- kArrayList<kSvDataInChannelEntry>

    kTcpClient client;                  //Client socket. 
    kSerializer serializer;             //Client data serializer. 

    kThread thread;                     //Thread to receive data. 
    kThreadPriorityClass threadPriorityClass;   //Desired thread priority class (low, med, high).
    k32s threadPriorityOffset;                  //Desired thread priority offset.
    kBitArray threadAffinity;                   //Desired thread affinity.

    kBool isSessionOpen;                //Should incoming data be accepted or discarded?
    k64s pendingEndSessionCount;        //Incremented when end-of-session message is expected from remote to sync session; decremented when received.
    kLock receiveLock;                  //Provides exclusive access to message dispatch.
    kAtomic32s hasExited;               //Is the channel still actively receiving?

    k64u bytesRead;                     //Number of bytes read. 
    k64u lastBytesRead;                 //Number of bytes read at time of last health update. 
    kLock statsLock;                    //Channel stats lock. 
} kSvDataInChannelClass; 

kDeclareClassEx(kFs, kSvDataInChannel, kObject)
        
kFsFx(kStatus) kSvDataInChannel_Init(kSvDataInChannel channel, kType type, kSvDataIn service, k32u sourceNode, 
                                     const kIpEndPoint* sourceEndPoint, kAlloc msgAlloc, kAlloc alloc); 

kFsFx(kStatus) kSvDataInChannel_VRelease(kSvDataInChannel channel);

kFsFx(kStatus) kSvDataInChannel_Disconnect(kSvDataInChannel channel);

kFsFx(kStatus) kSvDataInChannel_ThreadEntry(kSvDataInChannel channel); 

kFsFx(kStatus) kSvDataInChannel_SendConfiguration(kSvDataInChannel channel);
kFsFx(kBool) kSvDataInChannel_IsConfigurationReply(kObject object); 

kFsFx(kStatus) kSvDataInChannel_ReceiveNextMessage(kSvDataInChannel channel); 

kFsFx(kStatus) kSvDataInChannel_OnHealthUpdate(kSvDataInChannel channel, kObject sender, kPointer unused); 

#endif
