/** 
 * @file    kSvDataInChannel.h
 * @brief   Declares the kSvDataInChannel class and related types. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYC_SERVER_DATA_IN_CHANNEL_H
#define K_FIRESYC_SERVER_DATA_IN_CHANNEL_H

#include <kFireSync/Server/kSvDef.h>

/**
 * @internal
 * @class   kSvDataInChannel
 * @extends kObject
 * @ingroup kFireSync-Server-Network
 * @brief   Represents the client side of an FDSP-6 data connection. 
 */
//typedef kObject kSvDataInChannel;      --forward-declared in kFsDef.x.h

kFsFx(kStatus) kSvDataInChannel_Construct(kSvDataInChannel* channel, kSvDataIn service, k32u sourceNode, const kIpEndPoint* sourceEndPoint, kAlloc msgAlloc, kAlloc allocator); 

kFsFx(kStatus) kSvDataInChannel_SetSocketBufferSize(kSvDataInChannel channel, kSize socketBufferSize);

//can be called after initial connection established
kFsFx(kStatus) kSvDataInChannel_SetThreadPriority(kSvDataInChannel channel, kThreadPriorityClass priorityClass, k32s priorityOffset);

//can be called after initial connection established
kFsFx(kStatus) kSvDataInChannel_SetThreadAffinity(kSvDataInChannel channel, kBitArray affinity);

kFsFx(kStatus) kSvDataInChannel_AddPort(kSvDataInChannel channel, k16u sourcePortId, kPxPort destPort);

kFsFx(kStatus) kSvDataInChannel_Connect(kSvDataInChannel channel);

kFsFx(kStatus) kSvDataInChannel_BeginSession(kSvDataInChannel channel);
kFsFx(kStatus) kSvDataInChannel_EndSession(kSvDataInChannel channel, kBool synchronizeData);

kFsFx(k32u) kSvDataInChannel_SourceNode(kSvDataInChannel channel); 

kFsFx(const kIpEndPoint*) kSvDataInChannel_SourceEndPoint(kSvDataInChannel channel); 

kFsFx(kBool) kSvDataInChannel_IsActive(kSvDataInChannel channel); 

#include <kFireSync/Server/Network/kSvDataInChannel.x.h>

#endif
