/** 
 * @file    kSvIoTest.h
 * @brief   Declares the kSvIoTest class and related types. 
 *
 * @internal
 * Copyright (C) 2014-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYC_SERVER_IO_TEST_H
#define K_FIRESYC_SERVER_IO_TEST_H

#include <kFireSync/Server/kSvDef.h>

/**
 * @internal
 * @class       kSvIoTest
 * @extends     kObject
 * @ingroup     kFireSync-Server-Devices
 * @brief       Lightweight server wrapper for kHxIoTest. 
 */
//typedef kObject kSvIoTest;          --forward-declared in kFsDef.x.h

/** 
 * Constructs a kSvIoTest object.
 *
 * @public              @memberof kSvIoTest
 * @param   serial      Destination for the constructed object handle. 
 * @param   node        Server node (parent). 
 * @param   hwIoTest    I/O test hardware driver handle. 
 * @param   allocator   Memory allocator (or kNULL for default). 
 * @return              Operation status. 
 */
kFsFx(kStatus) kSvIoTest_Construct(kSvIoTest* serial, kSvNode node, kHxIoTest hwIoTest, kAlloc allocator);

#include <kFireSync/Server/Devices/kSvIoTest.x.h>

#endif
