/** 
 * @file    kSvEventManager.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYC_SERVER_EVENT_MANAGER_X_H
#define K_FIRESYC_SERVER_EVENT_MANAGER_X_H

typedef struct kSvEventManagerPrimeBackup
{
    kBool enabled; 
    kEventControl controlType; 
    kSyncDomain domain; 
    k64u offset;        
    k64u period;        
    k64u count;           
    kBool gateEnabled;  
    k32u phase;         //records "previous phase" value used for start scheduling
    kEventMissStyle missStyle;
    kBool cancellationEnabled;
} kSvEventManagerPrimeBackup;

typedef struct kSvEventManagerClass
{
    kObjectClass base; 
    
    kSvNode node;                   //Server node (parent). 
    kHxEvent hwEvent;               //Hardware event manager.

    kBool autoPeriodEnabled;        //AutoPeriodEnabled; affects client behaviour -- not stored in kHxEvent. 

    kSvEventManagerPrimeBackup primeBackup;     //settings backup; used when priming hardware to run

} kSvEventManagerClass; 

kDeclareClassEx(kFs, kSvEventManager, kObject)
        
kFsFx(kStatus) kSvEventManager_Init(kSvEventManager manager, kType type, kSvNode node, kHxEvent hwEvent, kAlloc alloc);
kFsFx(kStatus) kSvEventManager_VRelease(kSvEventManager manager);

#endif
