/** 
 * @file    kSvCamera.h
 * @brief   Declares the kSvCamera class and related types. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYC_SERVER_CAMERA_H
#define K_FIRESYC_SERVER_CAMERA_H

#include <kFireSync/Server/kSvDef.h>

/**
 * @internal
 * @class       kSvCamera
 * @extends     kObject
 * @ingroup     kFireSync-Server-Devices
 * @brief       Lightweight server wrapper for kHxCamera. 
 */
//typedef kObject kSvCamera;          --forward-declared in kFsDef.x.h

/** 
 * Constructs a kSvCamera object.
 *
 * @public              @memberof kSvCamera
 * @param   camera      Destination for the constructed object handle. 
 * @param   node        Server node (parent). 
 * @param   hwCamera    Camera hardware driver handle. 
 * @param   allocator   Memory allocator (or kNULL for default). 
 * @return              Operation status. 
 */
kFsFx(kStatus) kSvCamera_Construct(kSvCamera* camera, kSvNode node, kHxCamera hwCamera, kAlloc allocator);

kFsFx(kStatus) kSvCamera_FormatDevice(kSvCamera camera, kXml xml, kXmlItem item);
kFsFx(kStatus) kSvCamera_ParseDevice(kSvCamera camera, kXml xml, kXmlItem item);

kFsFx(kStatus) kSvCamera_Format(kSvCamera camera, kXml xml, kXmlItem item);
kFsFx(kStatus) kSvCamera_Parse(kSvCamera camera, kXml xml, kXmlItem item);

kFsFx(kStatus) kSvCamera_Prepare(kSvCamera camera);

kFsFx(kStatus) kSvCamera_Override(kSvCamera camera, const kCameraOverrideItem* overrides, kSize count);
kFsFx(kStatus) kSvCamera_CalibrateFpn(kSvCamera camera, kImage image);

kFsFx(kStatus) kSvCamera_WriteRamImage(kSvCamera camera, kSize stateIndex, kSize imageIndex, kImage image);
kFsFx(kStatus) kSvCamera_WritePrnu(kSvCamera camera, kImage white, kImage black);
kFsFx(kStatus) kSvCamera_WriteFpn(kSvCamera camera, kImage offsets);
kFsFx(kStatus) kSvCamera_WriteRangeLut(kSvCamera camera, const kRangeLutParams* params, const kRangeLutArray* xArray,
                                                            const kRangeLutArray* zArray, const kRangeLutArray* validArray);
kFsFx(kStatus) kSvCamera_WritePhaseDecoderLut(kSvCamera camera, kCameraPhaseDecoderLutType type, kArray1 lut);
kFsFx(kStatus) kSvCamera_SetLvdsPower(kSvCamera camera, k32u power);
kFsFx(kStatus) kSvCamera_LvdsPower(kSvCamera camera, k32u* power);
kFsFx(kStatus) kSvCamera_WriteAccelerationTestData(kSvCamera camera, kObject data);
kFsFx(kStatus) kSvCamera_ReadAccelerationTestResult(kSvCamera camera, kObject* data, kAlloc allocator);

kFsFx(kStatus) kSvCamera_ClearPrimeStats(kSvCamera camera);  //does not clear hw stats

kFsFx(kStatus) kSvCamera_Stats(kSvCamera camera, kCameraStats* stats);

kFsFx(kStatus) kSvCamera_Trigger(kSvCamera camera);

kFsFx(kBool) kSvCamera_ShouldPrime(kSvCamera camera);
kFsFx(kStatus) kSvCamera_PrepareForPrime(kSvCamera camera, k64u* period);
kFsFx(kStatus) kSvCamera_RestoreAfterPrime(kSvCamera camera);
kFsFx(kStatus) kSvCamera_OnDiscardData(kSvCamera camera, kHxCamera hwCamera, kPointer arguments);

#include <kFireSync/Server/Devices/kSvCamera.x.h>

#endif
