/** 
 * @file    kPxPort.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_PX_PORT_X_H
#define K_FIRESYNC_PX_PORT_X_H

typedef struct kPxPortClass
{
    kObjectClass base; 
    kPxBlock block;                     //Owner. 
    kText32 name;                       //Descriptive port name. 
    k32u id;                            //Unique port id. 
    kMsgSource address;                 //Message address associated with this port. 
    kPortDirection direction;           //Port directionality.
    kBool canAcceptForeignData;         //Can the port accept messages containing foreign memory space references?
    kBool asynchronousDataEnabled;      //Will the port emit messages asynchronously?
    kBool dropEnabled;                  //Can the port drop emitted messages?
    kArrayList connections;             //List of connected ports -- kArrayList<kPxPort>. 
    kQueue messages;                    //Queue of received messages -- kQueue<kMsgInfo>. 
} kPxPortClass; 

kDeclareClassEx(kFs, kPxPort, kObject)
        
kFsFx(kStatus) kPxPort_Construct(kPxPort* port, kPxBlock block, const kChar* name, k32u id, kPortDirection direction, kAlloc allocator); 
kFsFx(kStatus) kPxPort_Init(kPxPort port, kType type, kPxBlock block, const kChar* name, k32u id, kPortDirection direction, kAlloc alloc); 

kFsFx(kStatus) kPxPort_VRelease(kPxPort port); 

kFsFx(kStatus) kPxPort_ClearConnections(kPxPort port); 
kFsFx(kStatus) kPxPort_AddConnection(kPxPort port, kPxPort connection); 
kFsFx(kArrayList) kPxPort_Connections(kPxPort port); 

kFsFx(kMsgSource) kPxPort_Address(kPxPort port); 

kFsFx(kQueue) kPxPort_Messages(kPxPort port);

#endif
