/** 
 * @file    kPxEnviron.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_PX_ENVIRON_X_H
#define K_FIRESYNC_PX_ENVIRON_X_H

typedef struct kPxEnvironVTable
{   
    kStatus (kCall* VFindVariable)(kPxEnviron pipeEnviron, const kChar* name, kObject* object);
    kStatus (kCall* VFilePath)(kPxEnviron pipeEnviron, const kChar* fileName, kChar* filePath, kSize capacity);
    kStatus (kCall* VPrintvf)(kPxEnviron pipeEnviron, const kChar* format, va_list args);
    kAlloc (kCall* VMessageAlloc)(kPxEnviron pipeEnviron); 
    kHealth (kCall* VHealth)(kPxEnviron pipeEnviron); 
    k64u (kCall* VTimestamp)(kPxEnviron pipeEnviron); 
    kThreadPriorityClass (kCall* VThreadPriorityClass)(kPxEnviron pipeEnviron); 
    k32s (kCall* VThreadPriorityOffset)(kPxEnviron pipeEnviron); 
    kBitArray (kCall* VThreadAffinity)(kPxEnviron pipeEnviron); 
} kPxEnvironVTable;

kDeclareInterfaceEx(kFs, kPxEnviron, kNull) 
        
kFsFx(kStatus) kPxEnviron_VFindVariable(kPxEnviron pipeEnviron, const kChar* name, kObject* object);
kFsFx(kStatus) kPxEnviron_VFilePath(kPxEnviron pipeEnviron, const kChar* fileName, kChar* filePath, kSize capacity);
kFsFx(kStatus) kPxEnviron_VPrintvf(kPxEnviron pipeEnviron, const kChar* format, va_list args);
kFsFx(kAlloc) kPxEnviron_VMessageAlloc(kPxEnviron pipeEnviron);
kFsFx(kHealth) kPxEnviron_VHealth(kPxEnviron pipeEnviron);
kFsFx(k64u) kPxEnviron_VTimestamp(kPxEnviron pipeEnviron); 
kFsFx(kThreadPriorityClass) kPxEnviron_VThreadPriorityClass(kPxEnviron pipeEnviron);
kFsFx(k32s) kPxEnviron_VThreadPriorityOffset(kPxEnviron pipeEnviron);
kFsFx(kBitArray) kPxEnviron_VThreadAffinity(kPxEnviron pipeEnviron);

#endif
