/** 
 * @file    kArp.x.h
 *
 * @internal
 * Copyright (C) 2019-2022 by LMI Technologies Inc.
 */
#ifndef K_FIRESYNC_ARP_X_H
#define K_FIRESYNC_ARP_X_H

/* These constants are defined in https://tools.ietf.org/html/rfc5227 section 1.1 */
#define xkARP_ARP_PROBE_WAIT                (1000000)       ///< Initial maximum random delay (1 second).
#define xkARP_ARP_PROBE_COUNT               (3)             ///< Number of probe packets.
#define xkARP_ARP_PROBE_PROBE_MIN           (1000000)       ///< Minimum delay until repeated probe.
#define xkARP_ARP_PROBE_PROBE_MAX           (2000000)       ///< Maximum delay until repeated probe.

#define xkARP_ARP_ANNOUNCE_COUNT            (2)             //< Number of Announcement packets.
#define xkARP_ARP_ANNOUNCE_INTERVAL         (2000000)       //< Time between Announcement packets (2 seconds).

#define xkARP_OP_REQUEST                    (0x1)            //< ARP request.
#define xkARP_OP_REPLY                      (0x2)            //< ARP reply.

#define xkARP_ARP_PROTOCOL_TYPE_IPV4        (0x800)          //< IPv4 ARP protocol type.

typedef struct kArpClass
{
    kObjectClass base;

    kPacketSocket sockt;                        //RAW socket for sending/receiving.
    kBool isAttached;                           //Is socket externally owned?
    kBool isFirstCall;                          //Is this the first announcement?
    
    kPeriodic garpPeriodic;                     //Periodic used to send GARP messages.
    kIpAddress garpIpAddress;                   //IP address used for GARP.
    kMacAddress garpMacAddress;                 //MAC address used for GARP.
} kArpClass;

kDeclareClassEx(kFs, kArp, kObject)

/*
* Private methods.
*/

kFsFx(kStatus) xkArp_Init(kArp client, const kChar* adapterName, kType type, kAlloc alloc);
kFsFx(kStatus) xkArp_InitEx(kArp client, kPacketSocket sockt, kType type, kAlloc alloc);

kFsFx(kStatus) xkArp_VRelease(kArp arp);

kFsFx(kStatus) xkArp_OnGarpPeriodic(kArp arp, kPointer sender);
kFsFx(kStatus) xkArp_SendArp(kArp arp, kIpAddress sourceAddress, kIpAddress destAddress, kMacAddress sourceMacAddress);

kFsFx(kBool) xkArp_IsArpHeader(kByte* frame, kSize size);

#endif
