/**
* @file    kHostHealth.x.h
*
* @internal
* Copyright (C) 2016-2022 by LMI Technologies Inc.  All rights reserved.
*/
#ifndef K_FIRESYNC_HOST_HEALTH_X_H
#define K_FIRESYNC_HOST_HEALTH_X_H

#define kHOST_HEALTH_CPU_USED_AVERAGE_INTERVAL      (500000)    //CPU utilization is a moving average over this time period (us)
#define kHOST_HEALTH_CPU_USED_MIN_SAMPLE_INTERVAL   (100000)    //minimum time between two CPU utilization time-average samples (us)

#if defined(K_PLATFORM)

#   if defined(K_WINDOWS)

#       define kHostHealthPlatformFields()          \
            kHealthProbe cpuProbe;                  \
            kTimeAvg cpuAverage;                    \
            kArrayList cpuCoreProbes;               \
            kArrayList cpuCoreAverages;             \
            kHealthProbe memoryUsed;                \
            kHealthProbe memoryCapacity;            \
            kPointer query;                         \
            kPointer cpuHandle;                     \
            kArrayList cpuCoreHandles; 

#   elif defined(K_LINUX)

#       define kHostHealthPlatformFields()          \
            kArrayList coreProbes;                  \
            kArrayList coreAverages;                \
            kHealthProbe memoryUsed;                \
            kHealthProbe memoryCapacity;            \
            k64u cycleIndex;                        \
            kArray1 coreTicks[2];          //kArray1<kArray1<k64u>>[2]

#   endif
#endif

#if !defined(kHostHealthPlatformFields)
#   define kHostHealthPlatformFields()
#endif

typedef struct kHostHealthClass
{
    kHealthClass base;

    kHostHealthPlatformFields()
} kHostHealthClass;

kDeclareClassEx(kFs, kHostHealth, kHealth)

kFsFx(kStatus) kHostHealth_Init(kHostHealth health, kType type, kAlloc alloc);
kFsFx(kStatus) kHostHealth_VRelease(kHostHealth health);

kFsFx(kStatus) kHostHealth_BeginCollection(kHostHealth health);
kFsFx(kStatus) kHostHealth_EndCollection(kHostHealth health);
kFsFx(kStatus) kHostHealth_OnCollection(kHostHealth health, kPointer sender, kPointer args);

kFsFx(k32u) xkHostHealth_CpuUsed(kHostHealth health);
kFsFx(k64u) xkHostHealth_MemoryUsed(kHostHealth health);
kFsFx(k64u) xkHostHealth_MemoryCapacity(kHostHealth health);

#endif
