/**
* @file    kHostHealth.h
* @brief   Declares the kHostHealth type.
*
* @internal
* Copyright (C) 2016-2022 by LMI Technologies Inc.  All rights reserved.
*/
#ifndef K_FIRESYNC_HOST_HEALTH_H
#define K_FIRESYNC_HOST_HEALTH_H

#include <kFireSync/Health/kHealth.h>

/**
* @class   kHostHealth
* @extends kHealth
* @ingroup kFireSync-Health
* @brief   Provides health service for a typical host application. 
*
* This class extends kHealth to add support for some health indicators typically desired
* on host systems (e.g., cpu utilization).  This class can be instantiated by a host 
* application and installed as the global health provider for the application.
*/
//typedef kHealth kHostHealth;           --forward-declared in kFsDef.x.h  

/**
* Constructs a kHostHealth object.
*
* @public              @memberof kHostHealth
* @param   health      Destination for the constructed object handle.
* @param   allocator   Memory allocator (or kNULL for default).
* @return              Operation status.
*/
kFsFx(kStatus) kHostHealth_Construct(kHostHealth* health, kAlloc allocator);

#include <kFireSync/Health/kHostHealth.x.h>

#endif









