/** 
 * @file    kHealthProbe.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_HEALTH_PROBE_X_H
#define K_FIRESYNC_HEALTH_PROBE_X_H

/* 
 * kHealthProbe
 */

typedef struct kHealthProbeClass
{
    kObjectClass base; 

    kHealth provider;           //Health provider (or kNULL if no provider).
    kObject lock;               //Protects mutable state. 

    kHealthOption options;      //Options associated with health probe.
    kText64 name;               //Descriptive label (e.g. "Event0/QueueCount").
    k32u id;                    //Indicator type (or kHEALTH_ID_NULL). 
    k32u instance;              //Distinguishes multiple indicators with same id.
    k64s value;                 //Indicator value (units are indicator-specific). 
    k64s baseline;              //Baseline value (defaults to zero).

} kHealthProbeClass; 

typedef struct kHealthProbeVTable
{
    kObjectVTable base; 
    kStatus (kCall* VInitDefault)(kObject probe, kType type, const kChar* name, k32u id, k32u instance, k64s defaultValue, kHealth provider, kHealthOption options, kAlloc alloc); 
    kStatus (kCall* VSetBaseline)(kHealthProbe probe, k64s baseline); 
    kStatus (kCall* VUpdateBaseline)(kHealthProbe probe); 
    kStatus (kCall* VSetValue)(kHealthProbe probe, k64s value); 
    kStatus (kCall* VAddValue)(kHealthProbe probe, k64s value); 
    k64s (kCall* VValue)(kHealthProbe probe); 
    void (kCall* VStats)(kHealthProbe probe, kHealthStat* stat);
} kHealthProbeVTable; 

kDeclareVirtualClassEx(kFs, kHealthProbe, kObject)

kInlineFx(k64s) kHealthProbe_Value(kHealthProbe probe);

kFsFx(kStatus) xkHealthProbe_ConstructImpl(kHealthProbe* probe, const kChar* name, k32u id, k32u instance, k64s defaultValue, kHealth provider, kHealthOption options, kAlloc allocator);

kFsFx(kStatus) kHealthProbe_Init(kHealthProbe probe, kType type, const kChar* name, k32u id, k32u instance, k64s defaultValue, kHealth provider, kHealthOption options, kAlloc alloc);
kFsFx(kStatus) kHealthProbe_VInitDefault(kHealthProbe probe, kType type, const kChar* name, k32u id, k32u instance, k64s defaultValue, kHealth provider, kHealthOption options, kAlloc alloc);

kFsFx(kStatus) kHealthProbe_VRelease(kHealthProbe probe);

kFsFx(kStatus) kHealthProbe_VSetBaseline(kHealthProbe probe, k64s baseline);
kFsFx(kStatus) kHealthProbe_VUpdateBaseline(kHealthProbe probe);
kFsFx(kStatus) kHealthProbe_VSetValue(kHealthProbe probe, k64s value);
kFsFx(kStatus) kHealthProbe_VAddValue(kHealthProbe probe, k64s value);
kFsFx(k64s) kHealthProbe_VValue(kHealthProbe probe);

kFsFx(void) kHealthProbe_Stats(kHealthProbe probe, kHealthStat* stat);
kFsFx(void) kHealthProbe_VStats(kHealthProbe probe, kHealthStat* stat);

/* 
* Deprecated (Stage 1): not recommended for further use, but not yet announced via kDeprecate
*/

kInlineFx(kStatus) kHealthProbe_ConstructEx(kHealthProbe* probe, kHealth provider, const kChar* name, k32u id, k32u instance, k64s defaultValue, kAlloc allocator)
{
    return xkHealthProbe_ConstructImpl(probe, name, id, instance, defaultValue, provider, kHEALTH_OPTION_STREAM, allocator);
}

#endif
