/** 
 * @file    kHxTestJig.h
 * @brief   Declares the kHxTestJig class.
 *
 * @internal
 * Copyright (C) 2018-2022 by LMI Technologies Inc. All rights reserved.
 */
#ifndef K_FIRESYNC_HX_TEST_JIG_H
#define K_FIRESYNC_HX_TEST_JIG_H

#include <kFireSync/kNodeDef.h>
#include <kFireSync/Hardware/kHxTestJig.x.h>

/**
 * @class       kHxTestJig
 * @extends     kObject
 * @ingroup     kFireSync-Hardware
 * @internal
 * @brief       Abstract base class for hardware test jig classes.
 */
//typedef kObject kHxTestJig;      --forward-declared in kFsDef.x.h

kInlineFx(kHxNode) kHxTestJig_Node(kHxTestJig test)
{
    kObj(kHxTestJig, test); 

    return obj->node;
}

kInlineFx(kTestJigModel) kHxTestJig_Model(kHxTestJig test)
{
    kObj(kHxTestJig, test); 

    return obj->model;
}

kInlineFx(kStatus) kHxTestJig_Command(kHxTestJig test, kTestJigCommand command, k64u data)
{
    return xkHxTestJig_VTable(test)->VCommand(test, command, data);
}

kInlineFx(kStatus) kHxTestJig_Stats(kHxTestJig test, kTestJigStats* stats)
{
    return xkHxTestJig_VTable(test)->VStats(test, stats);
}

kInlineFx(kStatus) kHxTestJig_Clear(kHxTestJig test)
{
    return xkHxTestJig_VTable(test)->VClear(test);
}

#endif
