/** 
 * @file    kHxProjectorState.h
 * @brief   Declares the kHxProjectorState class.
 *
 * @internal
 * Copyright (C) 2018-2022 by LMI Technologies Inc. All rights reserved.
 */
#ifndef K_FIRESYNC_HX_PROJECTOR_STATE_H
#define K_FIRESYNC_HX_PROJECTOR_STATE_H

#include <kFireSync/kNodeDef.h>
#include <kFireSync/Hardware/kHxProjectorState.x.h>

/**
 * @class       kHxProjectorState
 * @extends     kObject
 * @ingroup     kFireSync-Hardware
 * @internal
 * @brief       Abstract base class for hardware projector-state classes.
 */
//typedef kObject kHxProjector;      --forward-declared in kFsDef.x.h

kInlineFx(kStatus) kHxProjectorState_SetIntensity(kHxProjectorState state, k32u intensity)
{
    kObj(kHxProjectorState, state);

    obj->intensity = intensity; 

    return kOK; 
}

kInlineFx(k32u) kHxProjectorState_Intensity(kHxProjectorState state)
{
    kObj(kHxProjectorState, state);

    return obj->intensity;
}

kInlineFx(kStatus) kHxProjectorState_SetExposure(kHxProjectorState state, k64u exposure)
{
    kObj(kHxProjectorState, state);

    obj->exposure = exposure; 

    return kOK; 
}

kInlineFx(k64u) kHxProjectorState_Exposure(kHxProjectorState state)
{
    kObj(kHxProjectorState, state);

    return obj->exposure; 
}

kInlineFx(kStatus) kHxProjectorState_SetGap(kHxProjectorState state, k64u gap)
{
    kObj(kHxProjectorState, state);

    obj->gap = gap; 

    return kOK; 
}

kInlineFx(k64u) kHxProjectorState_Gap(kHxProjectorState state)
{
    kObj(kHxProjectorState, state);

    return obj->gap;
}

#endif
