/** 
 * @file    kHxIoTest.h
 * @brief   Declares the kHxIoTest class.
 *
 * @internal
 * Copyright (C) 2018-2022 by LMI Technologies Inc. All rights reserved.
 */
#ifndef K_FIRESYNC_HX_IO_TEST_H
#define K_FIRESYNC_HX_IO_TEST_H

#include <kFireSync/kNodeDef.h>
#include <kFireSync/Hardware/kHxIoTest.x.h>

/**
 * @class       kHxIoTest
 * @extends     kObject
 * @ingroup     kFireSync-Hardware
 * @internal
 * @brief       Abstract base class for hardware IO test classes.
 */
//typedef kObject kHxIoTest;      --forward-declared in kFsDef.x.h

kInlineFx(kHxNode) kHxIoTest_Node(kHxIoTest test)
{
    kObj(kHxIoTest, test); 

    return obj->node;
}

kInlineFx(kSize) kHxIoTest_Index(kHxIoTest test)
{
    kObj(kHxIoTest, test); 

    return obj->index;
}

kInlineFx(kIoTestModel) kHxIoTest_Model(kHxIoTest test)
{
    kObj(kHxIoTest, test); 

    return obj->model;
}

kInlineFx(kStatus) kHxIoTest_SetSerialMode(kHxIoTest test, kIoTestSerialMode mode)
{
    kObj(kHxIoTest, test); 

    obj->serialMode = mode;

    return kOK; 
}

kInlineFx(kIoTestSerialMode) kHxIoTest_SerialMode(kHxIoTest test)
{
    kObj(kHxIoTest, test); 

    return obj->serialMode;
}

kInlineFx(kStatus) kHxIoTest_SetBitRate(kHxIoTest test, k32u rate)
{
    kObj(kHxIoTest, test); 

    obj->bitRate = rate;

    return kOK; 
}

kInlineFx(k32u) kHxIoTest_BitRate(kHxIoTest test)
{
    kObj(kHxIoTest, test); 

    return obj->bitRate;
}

kInlineFx(kStatus) kHxIoTest_SetG20x0MasterMode(kHxIoTest test, kBool masterMode)
{
    kObj(kHxIoTest, test); 

    obj->g20x0MasterMode = masterMode;

    return kOK; 
}

kInlineFx(kBool) kHxIoTest_G20x0MasterMode(kHxIoTest test)
{
    kObj(kHxIoTest, test); 

    return obj->g20x0MasterMode;
}

kInlineFx(kStatus) kHxIoTest_SetSafety(kHxIoTest test, kBool safety)
{
    kObj(kHxIoTest, test); 

    obj->safety = safety;

    return kOK; 
}

kInlineFx(kBool) kHxIoTest_Safety(kHxIoTest test)
{
    kObj(kHxIoTest, test); 

    return obj->safety;
}

kInlineFx(kStatus) kHxIoTest_SetDigitalOut(kHxIoTest test, kSize index, kBool state)
{
    kObj(kHxIoTest, test); 

    kCheckArgs(index < kHX_IO_TEST_DIGITAL_OUTPUT_COUNT);

    obj->digitalOutput[index] = state;

    return kOK; 
}

kInlineFx(kBool) kHxIoTest_DigitalOut(kHxIoTest test, kSize index)
{
    kObj(kHxIoTest, test); 

    kCheckArgs(index < kHX_IO_TEST_DIGITAL_OUTPUT_COUNT);

    return obj->digitalOutput[index];
}

kInlineFx(kStatus) kHxIoTest_SetSyncIo(kHxIoTest test, k32u syncIo)
{
    kObj(kHxIoTest, test); 

    obj->syncIo = syncIo;

    return kOK; 
}

kInlineFx(k32u) kHxIoTest_SyncIo(kHxIoTest test)
{
    kObj(kHxIoTest, test); 

    return obj->syncIo; 
}

kInlineFx(kStatus) kHxIoTest_SetMovingAvgWindow(kHxIoTest test, kSize window)
{
    kObj(kHxIoTest, test); 

    obj->movingAvgWindow = window;

    return kOK; 
}

kInlineFx(kSize) kHxIoTest_MovingAvgWindow(kHxIoTest test)
{
    kObj(kHxIoTest, test); 

    return obj->movingAvgWindow; 
}

kInlineFx(kStatus) kHxIoTest_Apply(kHxIoTest test)
{
    return xkHxIoTest_VTable(test)->VApply(test);
}

kInlineFx(kStatus) kHxIoTest_Stats(kHxIoTest test, kIoTestStats* stats)
{
    return xkHxIoTest_VTable(test)->VStats(test, stats);
}

kInlineFx(kStatus) kHxIoTest_ClearStats(kHxIoTest test)
{
    return xkHxIoTest_VTable(test)->VClearStats(test);
}

kInlineFx(kStatus) kHxIoTest_ReadSerial(kHxIoTest test, void* buffer, kSize capacity, kSize* bytesRead)
{
    return xkHxIoTest_VTable(test)->VReadSerial(test, buffer, capacity, bytesRead);
}

kInlineFx(kStatus) kHxIoTest_Reset(kHxIoTest test)
{
    return xkHxIoTest_VTable(test)->VReset(test);
}

kInlineFx(kStatus) kHxIoTest_Clear(kHxIoTest test)
{
    return xkHxIoTest_VTable(test)->VClear(test);
}

#endif
