/** 
 * @file    kHxEvent.h
 * @brief   Declares the kHxEvent class.
 *
 * @internal
 * Copyright (C) 2018-2022 by LMI Technologies Inc. All rights reserved.
 */
#ifndef K_FIRESYNC_HX_EVENT_H
#define K_FIRESYNC_HX_EVENT_H

#include <kFireSync/kNodeDef.h>
#include <kFireSync/Hardware/kHxEvent.x.h>

/**
 * @class       kHxEvent
 * @extends     kObject
 * @ingroup     kFireSync-Hardware
 * @internal
 * @brief       Abstract base class for hardware event manager classes.
 */
//typedef kObject kHxEvent;      --forward-declared in kFsDef.x.h

kInlineFx(kHxNode) kHxEvent_Node(kHxEvent manager)
{
    kObj(kHxEvent, manager); 

    return obj->node;
}

kInlineFx(kSize) kHxEvent_Index(kHxEvent manager)
{
    kObj(kHxEvent, manager); 

    return obj->index;
}

kInlineFx(kEventManagerType) kHxEvent_Type(kHxEvent manager)
{
    kObj(kHxEvent, manager); 

    return obj->eventType;
}

kInlineFx(kStatus) kHxEvent_Enable(kHxEvent manager, kBool enabled)
{
    kObj(kHxEvent, manager); 

    obj->enabled = enabled; 

    return kOK; 
}

kInlineFx(kBool) kHxEvent_IsEnabled(kHxEvent manager)
{
    kObj(kHxEvent, manager); 

    return obj->enabled; 
}

kInlineFx(kStatus) kHxEvent_SetControl(kHxEvent manager, kEventControl type)
{
    kObj(kHxEvent, manager); 

    obj->controlType = type; 

    return kOK; 
}

kInlineFx(kEventControl) kHxEvent_Control(kHxEvent manager)
{
    kObj(kHxEvent, manager); 

    return obj->controlType; 
}

kInlineFx(kStatus) kHxEvent_SetControlId(kHxEvent manager, kSize id)
{
    kObj(kHxEvent, manager); 

    obj->controlId = id; 

    return kOK; 
}

kInlineFx(kSize) kHxEvent_ControlId(kHxEvent manager)
{
    kObj(kHxEvent, manager); 

    return obj->controlId; 
}

kInlineFx(kStatus) kHxEvent_SetDomain(kHxEvent manager, kSyncDomain domain)
{
    kObj(kHxEvent, manager); 

    obj->domain = domain;

    return kOK; 
}

kInlineFx(kSyncDomain) kHxEvent_Domain(kHxEvent manager)
{
    kObj(kHxEvent, manager); 

    return obj->domain;
}

kInlineFx(kStatus) kHxEvent_SetEncoderMode(kHxEvent manager, kEventEncoder mode)
{
    kObj(kHxEvent, manager); 

    obj->encoderMode = mode;

    return kOK; 
}

kInlineFx(kEventEncoder) kHxEvent_EncoderMode(kHxEvent manager)
{
    kObj(kHxEvent, manager); 

    return obj->encoderMode;
}

kInlineFx(kStatus) kHxEvent_SetOffset(kHxEvent manager, k64u offset)
{
    kObj(kHxEvent, manager); 

    obj->offset = offset;

    return kOK; 
}

kInlineFx(k64u) kHxEvent_Offset(kHxEvent manager)
{
    kObj(kHxEvent, manager); 

    return obj->offset;
}


kInlineFx(kStatus) kHxEvent_SetCount(kHxEvent manager, k64u count)
{
    kObj(kHxEvent, manager); 

    obj->count = count;

    return kOK; 
}

kInlineFx(k64u) kHxEvent_Count(kHxEvent manager)
{
    kObj(kHxEvent, manager); 

    return obj->count;
}

kInlineFx(kStatus) kHxEvent_SetPeriod(kHxEvent manager, k64u period)
{
    kObj(kHxEvent, manager); 

    obj->period = period;

    return kOK; 
}

kInlineFx(k64u) kHxEvent_Period(kHxEvent manager)
{
    kObj(kHxEvent, manager); 

    return obj->period;
}

kInlineFx(kStatus) kHxEvent_EnableGate(kHxEvent manager, kBool enabled)
{
    kObj(kHxEvent, manager); 

    obj->gateEnabled = enabled;

    return kOK; 
}

kInlineFx(kBool) kHxEvent_GateEnabled(kHxEvent manager)
{
    kObj(kHxEvent, manager); 

    return obj->gateEnabled;
}

kInlineFx(kStatus) kHxEvent_SetPhase(kHxEvent manager, k32u phase)
{
    kObj(kHxEvent, manager); 

    obj->phase = phase;

    return kOK; 
}

kInlineFx(k32u) kHxEvent_Phase(kHxEvent manager)
{
    kObj(kHxEvent, manager); 

    return obj->phase;
}

kInlineFx(kStatus) kHxEvent_Stats(kHxEvent manager, kEventStats* stats)
{
    return xkHxEvent_VTable(manager)->VStats(manager, stats);
}

kInlineFx(kStatus) kHxEvent_Schedule(kHxEvent manager, k64s target)
{
    return xkHxEvent_VTable(manager)->VSchedule(manager, target);
}

kInlineFx(kStatus) kHxEvent_Trigger(kHxEvent manager)
{
    return xkHxEvent_VTable(manager)->VTrigger(manager);
}

kInlineFx(kStatus) kHxEvent_Clear(kHxEvent manager)
{
    return xkHxEvent_VTable(manager)->VClear(manager);
}

kInlineFx(kStatus) kHxEvent_SetMissStyle(kHxEvent manager, kEventMissStyle missStyle)
{
    kObj(kHxEvent, manager); 

    obj->missStyle = missStyle; 

    return kOK; 
}

kInlineFx(kEventMissStyle) kHxEvent_MissStyle(kHxEvent manager)
{
    kObj(kHxEvent, manager); 

    return obj->missStyle; 
}

kInlineFx(kStatus) kHxEvent_EnableCancellation(kHxEvent manager, kBool enabled)
{
    kObj(kHxEvent, manager); 

    obj->cancellationEnabled = enabled;

    return kOK; 
}

kInlineFx(kBool) kHxEvent_CancellationEnabled(kHxEvent manager)
{
    kObj(kHxEvent, manager); 

    return obj->cancellationEnabled;
}

#endif
