/** 
 * @file    kHxEncoder.h
 * @brief   Declares the kHxEncoder class.
 *
 * @internal
 * Copyright (C) 2018-2022 by LMI Technologies Inc. All rights reserved.
 */
#ifndef K_FIRESYNC_HX_ENCODER_H
#define K_FIRESYNC_HX_ENCODER_H

#include <kFireSync/kNodeDef.h>
#include <kFireSync/Hardware/kHxEncoder.x.h>

/**
 * @class       kHxEncoder
 * @extends     kObject
 * @ingroup     kFireSync-Hardware
 * @internal
 * @brief       Abstract base class for hardware encoder classes.
 */
//typedef kObject kHxEncoder;      --forward-declared in kFsDef.x.h

kInlineFx(kHxNode) kHxEncoder_Node(kHxEncoder encoder)
{
    kObj(kHxEncoder, encoder); 

    return obj->node;
}

kInlineFx(kStatus) kHxEncoder_Enable(kHxEncoder encoder, kBool enabled)
{
    kObj(kHxEncoder, encoder); 

    obj->enabled = enabled; 

    return kOK; 
}

kInlineFx(kBool) kHxEncoder_IsEnabled(kHxEncoder encoder)
{
    kObj(kHxEncoder, encoder); 

    return obj->enabled; 
}

kInlineFx(kStatus) kHxEncoder_SetDirection(kHxEncoder encoder, kEncoderDirection direction)
{
    kObj(kHxEncoder, encoder); 

    obj->direction = direction; 

    return kOK; 
}

kInlineFx(kEncoderDirection) kHxEncoder_Direction(kHxEncoder encoder)
{
    kObj(kHxEncoder, encoder); 

    return obj->direction; 
}

kInlineFx(kStatus) kHxEncoder_EnableIndexReset(kHxEncoder encoder, kBool indexReset)
{
    kObj(kHxEncoder, encoder); 

    obj->indexReset = indexReset; 

    return kOK; 
}

kInlineFx(kBool) kHxEncoder_IndexResetEnabled(kHxEncoder encoder)
{
    kObj(kHxEncoder, encoder); 

    return obj->indexReset; 
}

kInlineFx(kStatus) kHxEncoder_EnableSimulation(kHxEncoder encoder, kBool enable)
{
    kObj(kHxEncoder, encoder); 

    obj->simulatorEnabled = enable; 

    return kOK; 
}

kInlineFx(kBool) kHxEncoder_SimulationEnabled(kHxEncoder encoder)
{
    kObj(kHxEncoder, encoder); 

    return obj->simulatorEnabled; 
}

kInlineFx(kStatus) kHxEncoder_SetSimulationDirection(kHxEncoder encoder, kBool isForward)
{
    kObj(kHxEncoder, encoder); 

    obj->simulatorDirection = isForward; 

    return kOK; 
}

kInlineFx(kBool) kHxEncoder_SimulationDirection(kHxEncoder encoder)
{
    kObj(kHxEncoder, encoder); 

    return obj->simulatorDirection; 
}

kInlineFx(kStatus) kHxEncoder_SetSimulationPeriod(kHxEncoder encoder, k64u period)
{
    kObj(kHxEncoder, encoder); 

    obj->simulatorPeriod = period; 

    return kOK; 
}

kInlineFx(k64u) kHxEncoder_SimulationPeriod(kHxEncoder encoder)
{
    kObj(kHxEncoder, encoder); 

    return obj->simulatorPeriod; 
}

kInlineFx(kStatus) kHxEncoder_SetSimulationResolution(kHxEncoder encoder, k32u resolution)
{
    kObj(kHxEncoder, encoder); 

    obj->simulatorResolution = resolution; 

    return kOK; 
}

kInlineFx(k32u) kHxEncoder_SimulationResolution(kHxEncoder encoder)
{
    kObj(kHxEncoder, encoder); 

    return obj->simulatorResolution;
}

kInlineFx(kStatus) kHxEncoder_SetSnapshotSource(kHxEncoder encoder, kEncoderSnapshotSource source)
{
    kObj(kHxEncoder, encoder); 

    obj->snapshotSource = source; 

    return kOK; 
}

kInlineFx(kEncoderSnapshotSource) kHxEncoder_SnapshotSource(kHxEncoder encoder)
{
    kObj(kHxEncoder, encoder); 

    return obj->snapshotSource;
}

kInlineFx(kStatus) kHxEncoder_SetSnapshotSourceId(kHxEncoder encoder, k32u id)
{
    kObj(kHxEncoder, encoder); 

    obj->snapshotSourceId = id; 

    return kOK; 
}

kInlineFx(k32u) kHxEncoder_SnapshotSourceId(kHxEncoder encoder)
{
    kObj(kHxEncoder, encoder); 

    return obj->snapshotSourceId;
}

kInlineFx(kStatus) kHxEncoder_Apply(kHxEncoder encoder)
{
    return xkHxEncoder_VTable(encoder)->VApply(encoder);
}

kInlineFx(kStatus) kHxEncoder_Reset(kHxEncoder encoder)
{
    return xkHxEncoder_VTable(encoder)->VReset(encoder);
}

kInlineFx(kStatus) kHxEncoder_Clear(kHxEncoder encoder)
{
    return xkHxEncoder_VTable(encoder)->VClear(encoder);
}

kInlineFx(kStatus) kHxEncoder_ClearDevice(kHxEncoder encoder)
{
    return xkHxEncoder_VTable(encoder)->VClearDevice(encoder);
}

#endif
