/** 
 * @file    kHxCameraState.x.h
 *
 * @internal
 * Copyright (C) 2018-2022 by LMI Technologies Inc. All rights reserved.
 */
#ifndef K_FIRESYNC_HX_CAMERA_STATE_X_H
#define K_FIRESYNC_HX_CAMERA_STATE_X_H

typedef struct kHxCameraStateVTable
{
    kObjectVTable base;

    kStatus (kCall* VSetRamImageCount)(kHxCameraState state, kSize count);
    kSize (kCall* VRamImageCount)(kHxCameraState state);
    kStatus (kCall* VWriteRamImage)(kHxCameraState state, kSize imageIndex, kImage image);

} kHxCameraStateVTable;

typedef struct kHxCameraStateClass
{
    kObjectClass base; 

    /* 
     * Read-only attributes established during init.
     */

    kHxCamera camera;                   //Parent.
    kSize id;                           //Index of object in context of parent.

    /* 
     * Dynamic properties that are automatically initialized during init. 
     */

    kCameraExposure exposureMode;       //Camera exposure mode setting.
    kSize maxBatchSize;                 //Maximum count of frames in one message setting.

    k64u delay;                         //Delay setting (FS ns). 
    k64u exposure;                      //Exposure setting (FS ns). 
    k64u gap;                           //Gap setting (FS ns).
    k64u leadIn;                        //Invididual lead-in (FS ns).
    k64u leadOut;                       //Individual lead-out (FS ns).
    k64u totalLeadIn;                   //Total lead-in across synchronized modules (FS ns).
    k64u totalLeadOut;                  //Total lead-out across synchronized modules (FS ns).
    k64u readoutTime;                   //Imager readout time (FS ns).
    k64u interExposureGap;              //Imager minimum inter-exposure time (FS ns).

    k32u gain[kCAMERA_GAIN_CAPACITY];   //Gain level settings.
    kBool autoBlack;                    //Automatic black-level enabled setting.
    k32s blackLevel;                    //Black level setting.
    kArrayList kneePoints;              //Multi-slope knee point settings.

    k32u top;                           //Window top setting.
    k32u left;                          //Window left setting.
    k32u width;                         //Window width setting.
    k32u height;                        //Window height setting.
    kCameraSubsampling xSubMode;        //X-subsampling mode setting.
    k32u xSub;                          //X-subsampling amount setting.
    kCameraSubsampling ySubMode;        //Y-subsampling mode setting.
    k32u ySub;                          //Y-subsampling amount setting.
    kBool invertX;                      //X-invert setting.
    kBool invertY;                      //Y-invert setting.

    kAlgInfo algInfo;                   //Algorithm settings; constructed by base.

} kHxCameraStateClass; 

kDeclareVirtualClassEx(kFs, kHxCameraState, kObject)

kFsFx(kStatus) xkHxCameraState_Init(kHxCameraState state, kType type, kHxCamera camera, kSize id, kCameraAlgorithm algorithmId, kAlloc alloc); 

kFsFx(kStatus) xkHxCameraState_VRelease(kHxCameraState state); 

kInlineFx(kStatus) xkHxCameraState_VSetRamImageCount(kHxCameraState state, kSize count)
{
    return kERROR_UNIMPLEMENTED;
}

kInlineFx(kSize) xkHxCameraState_VRamImageCount(kHxCameraState state)
{
    return 0;
}

kInlineFx(kStatus) xkHxCameraState_VWriteRamImage(kHxCameraState state, kSize imageIndex, kImage image)
{
    return kERROR_UNIMPLEMENTED;
}

#endif
