/** 
 * @file    kHxCamera.x.h
 *
 * @internal
 * Copyright (C) 2018-2022 by LMI Technologies Inc. All rights reserved.
 */
#ifndef K_FIRESYNC_HX_CAMERA_X_H
#define K_FIRESYNC_HX_CAMERA_X_H

kDeclareValueEx(kFs, kHxCameraStreamType, kValue)
kDeclareValueEx(kFs, kHxCameraDataArgs, kValue)

typedef struct kHxCameraVTable
{
    kObjectVTable base; 

    kBool   (kCall* VIsConnected)(kHxCamera camera);
    kStatus (kCall* VSetVideoBufferSize)(kHxCamera camera, kSize requestedSize);
    kSize (kCall* VVideoBufferSize)(kHxCamera camera);
    kStatus (kCall* VSetAlgorithmBufferSize)(kHxCamera camera, kSize requestedSize);
    kSize (kCall* VAlgorithmBufferSize)(kHxCamera camera);
    kStatus (kCall* VAllocateBuffer)(kHxCamera camera);
    kStatus (kCall* VSetStateCount)(kHxCamera camera, kSize count);
    k32u (kCall* VPrimeCount)(kHxCamera camera);
    kStatus (kCall* VAddExtension)(kHxCamera camera, kCameraExt extension);
    kStatus (kCall* VWritePrnu)(kHxCamera camera, kImage white, kImage black);
    kStatus (kCall* VWriteFpn)(kHxCamera camera, kImage offsets);
    kStatus (kCall* VCalibrateFpn)(kHxCamera camera, kImage image);
    kStatus (kCall* VWriteRangeLut)(kHxCamera camera, const kRangeLutParams* params, const kRangeLutArray* xArray, const kRangeLutArray* zArray, const kRangeLutArray* validArray);
    kStatus (kCall* VWritePhaseDecoderLut)(kHxCamera camera, kCameraPhaseDecoderLutType type, kArray1 lut);
    kStatus (kCall* VWriteAccelerationTestData)(kHxCamera camera, kObject data);
    kStatus (kCall* VReadAccelerationTestResult)(kHxCamera camera, kObject* data, kAlloc allocator);
    kSize   (kCall* VImagerRegisterCapacity)(kHxCamera camera); 
    k32u    (kCall* VReadImagerRegister)(kHxCamera camera, kSize registerIndex); 
    kStatus (kCall* VWriteImagerRegister)(kHxCamera camera, kSize registerIndex, k32u value); 
    kStatus (kCall* VSendDynamicFpnImage)(kHxCamera camera, kImage image);
    kStatus (kCall* VSetLvdsPower)(kHxCamera camera, k32u power, kBool commit);
    kStatus (kCall* VStats)(kHxCamera camera, kCameraStats* stats);
    kStatus (kCall* VOverride)(kHxCamera camera, const kCameraOverrideItem* overrides, kSize count);
    kStatus (kCall* VTrigger)(kHxCamera camera);
    kStatus (kCall* VClear)(kHxCamera camera);
    kStatus (kCall* VCalibrate)(kHxCamera camera);
 
} kHxCameraVTable;

typedef struct kHxCameraClass
{
    kObjectClass base;  

    /* 
     * Read-only attributes established during init.
     */

    kHxNode node;                                   //Parent.
    kSize index;                                    //Index of this object in parent context.
    kText32 label;                                  //Text label, used for diagnostics.

    /* 
     * Read-only attributes that must be established by descendant during descendant init.
     */

    kCameraInfo info;                               //Camera model information (must be constructed by descendant classes).
    kCameraCapability capabilities;                 //Capabilities bitset.
    kCameraAlgorithm algorithm;                     //Algorithm type.
    k64f pixelClockFrequency;                       //PL Pixel clock frequency (Hz).
    k32u channelCount;                              //Number of imager channels.
    k32u plPipeCount;                               //Number of PL camera pipes.
    kBool isTrailingRequired;                       //Is trailing required padded to end of frame?
    kSize frameSizeGranularity;                     //Frame size granularity shift bits.
    kCameraOutputMode outputCapabilities;           //Output capabilities.

    /* 
     * Callbacks; can optionally be set to receive events.  
     */

    kCallback dataCallback;                         //Data message handler. 

    /* 
     * Dynamic properties that can be re/initialized by calling Clear method from descendant. 
     */

    kCameraOutputMode outputMode;                       //Output mode setting.
    kCameraPortMode portMode;                           //Port mode setting.

    kBool enabled;                                      //Camera enabled setting.
    kCameraControl controlType;                         //Control mode setting.
    kSize controlId;                                    //Control id setting.

    kCameraReadout readoutMode;                         //Readout mode setting.

    kBool ramImageEnabled;                              //RAM Image enabled setting.
    kBool prnuEnabled;                                  //PRNU enabled setting.
    kBool fpnEnabled;                                   //FPN enabled setting.
    kBool calibrationEnabled;                           //Imager calibration enabled setting.
    kBool testPatternEnabled;                           //Test pattern enabled setting.
    kCameraAccelerationTestMode accelerationTestMode;   //Acceleration test mode.

    kCameraInputCounterSource inputCounterSource;       //Camera input counter source setting.
    k32u inputCounterSourceId;                          //Input counter source id setting.

    k32u lvdsPower;                                     //LVDS power strength setting.
    k32u reductionFactor;                               //Bandwidth reduction factor setting.
    k32u reductionWindow;                               //Bandwidth reduction window setting.

    k64u duration;                                      //Total exposure sequence duration; precalculated by client; in FS ns.

    kArrayList states;                                  //Camera states; list constructed by base, elements added by descendant -- kArrayList<kHxCameraState>. 
    kArrayList extensions;                              //Camera control extensions; list constructed by base, elements added by descendant -- kArrayList<kHxCameraExt>.

} kHxCameraClass;

kDeclareVirtualClassEx(kFs, kHxCamera, kObject)

/*
* Protected 
*/

kFsFx(kStatus) xkHxCamera_Init(kHxCamera camera, kType type, kHxNode node, kSize index, kAlloc alloc); 

kFsFx(kStatus) xkHxCamera_VRelease(kHxCamera camera); 

kInlineFx(kBool) xkHxCamera_VIsConnected(kHxCamera camera)
{
    return kFALSE;
}

kInlineFx(const kChar*) xkHxCamera_Label(kHxCamera camera)
{
    kObj(kHxCamera, camera);
    return obj->label;
}

kInlineFx(kStatus) xkHxCamera_VSetVideoBufferSize(kHxCamera camera, kSize requestedSize)
{
    return kERROR_UNIMPLEMENTED;
}

kInlineFx(kSize) xkHxCamera_VVideoBufferSize(kHxCamera camera)
{
    return 0;
}

kInlineFx(kStatus) xkHxCamera_VSetAlgorithmBufferSize(kHxCamera camera, kSize requestedSize)
{
    return kERROR_UNIMPLEMENTED;
}

kInlineFx(kSize) xkHxCamera_VAlgorithmBufferSize(kHxCamera camera)
{
    return 0;
}

kInlineFx(kStatus) xkHxCamera_VAllocateBuffer(kHxCamera camera)
{
    return kERROR_UNIMPLEMENTED;
}

kInlineFx(kStatus) xkHxCamera_VSetStateCount(kHxCamera camera, kSize count)
{
    return kERROR_UNIMPLEMENTED;
}

kInlineFx(k32u) xkHxCamera_VPrimeCount(kHxCamera camera)
{
    return 0;
}

kInlineFx(kStatus) xkHxCamera_VAddExtension(kHxCamera camera, kCameraExt extension)
{
    return kERROR_UNIMPLEMENTED;
}

kInlineFx(kStatus) xkHxCamera_VWritePrnu(kHxCamera camera, kImage white, kImage black)
{
    return kERROR_UNIMPLEMENTED;
}

kInlineFx(kStatus) xkHxCamera_VWriteFpn(kHxCamera camera, kImage offsets)
{
    return kERROR_UNIMPLEMENTED;
}

kInlineFx(kStatus) xkHxCamera_VCalibrateFpn(kHxCamera camera, kImage image)
{
    return kERROR_UNIMPLEMENTED;
}

kInlineFx(kStatus) xkHxCamera_VWriteRangeLut(kHxCamera camera, const kRangeLutParams* params, const kRangeLutArray* xArray,
                                                             const kRangeLutArray* zArray, const kRangeLutArray* validArray)
{
    return kERROR_UNIMPLEMENTED;
}

kInlineFx(kStatus) xkHxCamera_VWritePhaseDecoderLut(kHxCamera camera, kCameraPhaseDecoderLutType type, kArray1 lut)
{
    return kERROR_UNIMPLEMENTED;
}

kInlineFx(kStatus) xkHxCamera_VWriteAccelerationTestData(kHxCamera camera, kObject data)
{
    return kERROR_UNIMPLEMENTED;
}

kInlineFx(kStatus) xkHxCamera_VReadAccelerationTestResult(kHxCamera camera, kObject* data, kAlloc allocator)
{
    return kERROR_UNIMPLEMENTED;
}

kInlineFx(kSize) xkHxCamera_VImagerRegisterCapacity(kHxCamera camera)
{
    return 0;
}

kInlineFx(k32u) xkHxCamera_VReadImagerRegister(kHxCamera camera, kSize registerIndex)
{
    return 0;
}

kInlineFx(kStatus) xkHxCamera_VWriteImagerRegister(kHxCamera camera, kSize registerIndex, k32u value)
{
    return kERROR_UNIMPLEMENTED;
}

//callee should add ref to retain image, if desired
kInlineFx(kStatus) xkHxCamera_VSendDynamicFpnImage(kHxCamera camera, kImage image)
{
    return kERROR_UNIMPLEMENTED;
}

kInlineFx(kStatus) xkHxCamera_VSetLvdsPower(kHxCamera camera, k32u power, kBool commit)
{
    return kOK;
}

kInlineFx(kStatus) xkHxCamera_VCalibrate(kHxCamera camera)
{
    return kERROR_UNIMPLEMENTED;
}

kInlineFx(kStatus) xkHxCamera_VStats(kHxCamera camera, kCameraStats* stats)
{
    return kERROR_UNIMPLEMENTED;
}

kInlineFx(kStatus) xkHxCamera_VTrigger(kHxCamera camera)
{
    return kERROR_UNIMPLEMENTED;
}

kInlineFx(kStatus) xkHxCamera_VOverride(kHxCamera camera, const kCameraOverrideItem* overrides, kSize count)
{
    return kERROR_UNIMPLEMENTED;
}

//can optionally be overridden, but probably doesn't need to be
kFsFx(kStatus) xkHxCamera_VClear(kHxCamera camera);

kFsFx(k32u) xkHxCamera_MaxColumns(kHxCamera camera);

#endif
