/** 
 * @file    kHxLightExt.x.h
 *
 * @internal
 * Copyright (C) 2018-2022 by LMI Technologies Inc. All rights reserved.
 */
#ifndef K_FIRESYNC_HX_LIGHT_EXT_X_H
#define K_FIRESYNC_HX_LIGHT_EXT_X_H

typedef struct kHxLightExtVTable
{
    kObjectVTable base;  

    kStatus (kCall* VOverride)(kHxLightExt extension, const kLightOverrideItem* overrides, kSize count);
    
} kHxLightExtVTable;

typedef struct kHxLightExtClass
{
    kObjectClass base;     

    /* 
     * Read-only attributes established during init.
     */

    kHxLight light;            //Parent.
    kLightExt config;          //Configuration object.

} kHxLightExtClass;

kDeclareVirtualClassEx(kFs, kHxLightExt, kObject)

//instances of this class can be constructed by hardware implementations that do not subclass extensions (i.e., kHwVirtual). 
kFsFx(kStatus) xkHxLightExt_Construct(kHxLightExt* extension, kHxLight light, kLightExt config, kAlloc allocator);

kFsFx(kStatus) xkHxLightExt_Init(kHxLightExt ext, kType type, kHxLight light, kLightExt config, kAlloc alloc);

kFsFx(kStatus) xkHxLightExt_VRelease(kHxLightExt ext); 

kInlineFx(kStatus) xkHxLightExt_VOverride(kHxLightExt ext, const kLightOverrideItem* overrides, kSize count)
{
    return kERROR_UNIMPLEMENTED;
}

#endif
