/** 
 * @file    kHxCameraExt.h
 * @brief   Declares the kHxCameraExt class.
 *
 * @internal
 * Copyright (C) 2018-2022 by LMI Technologies Inc. All rights reserved.
 */
#ifndef K_FIRESYNC_HX_CAMERA_EXT_H
#define K_FIRESYNC_HX_CAMERA_EXT_H

#include <kFireSync/kNodeDef.h>
#include <kFireSync/Hardware/Camera/kHxCameraExt.x.h>

/**
 * @class       kHxCameraExt
 * @extends     kObject
 * @ingroup     kFireSync-Hardware-Camera
 * @internal
 * @brief       Abstract base class for hardware camera extension classes.
 */
//typedef kObject kHxCameraExt;      --forward-declared in kFsDef.x.h

kInlineFx(kStatus) kHxCameraExt_Override(kHxCameraExt ext, const kCameraOverrideItem* overrides, kSize count)
{
    return xkHxCameraExt_VTable(ext)->VOverride(ext, overrides, count);
}

kInlineFx(kCameraExt) kHxCameraExt_Config(kHxCameraExt ext)
{
    kObj(kHxCameraExt, ext); 

    return obj->config;
}

#endif
