/** 
 * @file    kTerrain.x.h
 *
 * @internal
 * Copyright (C) 2008-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_TERRAIN_X_H
#define K_FIRESYNC_TERRAIN_X_H

#define kTERRAIN_MAX_OVERLAYS      5

typedef struct kTerrainClass 
{
    kObjectClass base;
    kImage profile;
    kImage overlays[kTERRAIN_MAX_OVERLAYS];
    kBool invertProfileHeight;
    kPoint3d32s worldTopLeft;
    kPoint3d32s worldBottomLeft;
    kPoint3d32s worldBottomRight;
    kSize overlayCount;
} kTerrainClass;

kDeclareClassEx(kFs, kTerrain, kObject)

kFsFx(kStatus) xkTerrain_ConstructFramework(kTerrain* terrain, kAlloc allocator); 

kFsFx(kStatus) kTerrain_Init(kTerrain terrain, kType classType, kImage profile, kAlloc allocator);

kFsFx(kStatus) kTerrain_VRelease(kTerrain result);
kFsFx(kStatus) kTerrain_VClone(kTerrain terrain, kTerrain source, kAlloc valueAlloc, kObject context);
kFsFx(kStatus) kTerrain_VDisposeItems(kTerrain terrain);
kFsFx(kBool) kTerrain_VHasShared(kTerrain terrain);
kFsFx(kSize) kTerrain_VSize(kTerrain terrain);
kFsFx(kAllocTrait) kTerrain_VAllocTraits(kTerrain terrain);

kFsFx(kStatus) xkTerrain_WriteDat6V0(kTerrain terrain, kSerializer serializer);
kFsFx(kStatus) xkTerrain_ReadDat6V0(kTerrain terrain, kSerializer serializer);

#endif
