/** 
 * @file    kPlot.x.h
 *
 * @internal
 * Copyright (C) 2008-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_API_PLOT_X_H
#define K_API_PLOT_X_H

#include <kFireSync/Data/kPlot.h>

// TODO NOTE: changing these constants will break compat (writing FS5 data)
#define kPLOT_CAPACITY                              (64)
#define kPLOT_ITEM_TEXT_CAPACITY                    (64)
#define kPLOT_TITLE_CAPACITY                        (64)

typedef struct kPlotItemStruct 
{
    kObject object;
    kChar   name[kPLOT_ITEM_TEXT_CAPACITY];
} kPlotItemStruct;

typedef kPointer kPlotItem;

typedef struct kPlotClass 
{
    kObjectClass base; 

    k32f x;
    k32f y;
    k32f z;
    k32f width;
    k32f height;
    k32f depth;

    kColor backColor;
    kChar title[kPLOT_TITLE_CAPACITY];
    kChar xTitle[kPLOT_TITLE_CAPACITY];
    kChar yTitle[kPLOT_TITLE_CAPACITY];
    kChar zTitle[kPLOT_TITLE_CAPACITY];
    kChar profilerTitle[kPLOT_TITLE_CAPACITY];
    kPlotItemStruct items[kPLOT_CAPACITY];
    kSize count;
} kPlotClass;

kDeclareClassEx(kFs, kPlot, kObject)

/* 
* Forward declarations. 
*/

kInlineFx(kSize) kPlot_Count(kPlot plot);

/* 
* Private methods. 
*/

kInlineFx(kPlotItemStruct*) xkPlot_ItemAt(kPlot plot, kSize index)
{
    kObj(kPlot, plot);

    kAssert(index < kCountOf(obj->items)); 

    return &obj->items[index]; 
}

kFsFx(kStatus) kPlot_Init(kPlot plot, kType classType, kAlloc allocator);
kFsFx(kStatus) kPlot_VClone(kPlot plot, kPlot source, kAlloc valueAlloc, kObject context);
kFsFx(kBool) kPlot_VHasShared(kPlot plot);
kFsFx(kSize) kPlot_VSize(kPlot plot);
kFsFx(kAllocTrait) kPlot_VAllocTraits(kPlot plot);
kFsFx(kStatus) kPlot_VRelease(kPlot plot);

kFsFx(kStatus) xkPlot_WriteDat5V1(kPlot plot, kSerializer serializer);
kFsFx(kStatus) xkPlot_ReadDat5V1(kPlot plot, kSerializer serializer);
kFsFx(kStatus) xkPlot_WriteDat5V2(kPlot plot, kSerializer serializer);
kFsFx(kStatus) xkPlot_ReadDat5V2(kPlot plot, kSerializer serializer);
kFsFx(kStatus) xkPlot_WriteDat6V0(kPlot plot, kSerializer serializer);
kFsFx(kStatus) xkPlot_ReadDat6V0(kPlot plot, kSerializer serializer);

kFsFx(kStatus) kPlot_Clear(kPlot plot);
kFsFx(kStatus) kPlot_SetItemLabel(kPlot plot, kPlotItem item, const kChar* label);
kFsFx(kRect32f) kPlot_World(kPlot plot);

#endif
