/** 
 * @file    kMsgInfo.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_MSG_INFO_X_H
#define K_FIRESYNC_MSG_INFO_X_H

typedef struct kMsgInfoClass
{
    kObjectClass base; 
    kMsgSource source; 
    kSize tag; 
    kMsgSet message; 
} kMsgInfoClass; 

kDeclareClassEx(kFs, kMsgInfo, kObject)

kFsFx(kStatus) xkMsgInfo_ConstructFramework(kMsgInfo* info, kAlloc allocator); 

kFsFx(kStatus) kMsgInfo_Init(kMsgInfo info, kType type, kMsgSource source, kSize tag, kMsgSet message, kAlloc alloc); 

kFsFx(kStatus) kMsgInfo_VClone(kMsgInfo info, kMsgInfo source, kAlloc valueAlloc, kObject context); 

kFsFx(kStatus) kMsgInfo_VRelease(kMsgInfo info); 
kFsFx(kStatus) kMsgInfo_VDisposeItems(kMsgInfo info); 

kFsFx(kBool) kMsgInfo_VHasShared(kMsgInfo info); 
kFsFx(kSize) kMsgInfo_VSize(kMsgInfo info); 
kFsFx(kAllocTrait) kMsgInfo_VAllocTraits(kMsgInfo info);

kFsFx(kStatus) xkMsgInfo_WriteDat6V0(kMsgInfo info, kSerializer serializer); 
kFsFx(kStatus) xkMsgInfo_ReadDat6V0(kMsgInfo info, kSerializer serializer); 

#endif
