/** 
 * @file    kMsg.h
 * @brief   Declares the kMsg type. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_MSG_H
#define K_FIRESYNC_MSG_H

#include <kFireSync/Data/kMsgSet.h>
#include <kFireSync/Data/kMsg.x.h>

/**
 * @class   kMsg
 * @extends kMsgSet
 * @ingroup kFireSync-Data
 * @brief   Represents a simple data message. 
 */
//typedef kMsgSet kMsg;            --forward-declared in kFsDef.x.h

/** 
 * Constructs a kMsg object.
 *
 * @public              @memberof kMsg
 * @param   msg         Destination for the constructed object handle. 
 * @param   stamp       Stamp value for this message (can be kNULL).  
 * @param   data        Data content for this message (can be kNULL).  
 * @param   allocator   Memory allocator (or kNULL for default). 
 * @return              Operation status. 
 */
kFsFx(kStatus) kMsg_Construct(kMsg* msg, const kStamp* stamp, kObject data, kAlloc allocator); 

/** 
 * Sets the message stamp. 
 *
 * @public             @memberof kMsg
 * @param   msg        kMsg object. 
 * @param   stamp      Stamp value. 
 * @return             Operation status. 
 */
kFsFx(kStatus) kMsg_SetStamp(kMsg msg, const kStamp* stamp);

/** 
 * Gets the message stamp. 
 *
 * @public             @memberof kMsg
 * @param   msg        kMsg object. 
 * @return             Stamp value. 
 */
kInlineFx(kStamp*) kMsg_Stamp(kMsg msg)
{
    kObj(kMsg, msg); 

    return &obj->stamp; 
}

/** 
 * Sets the message content. 
 *
 * @public             @memberof kMsg
 * @param   msg        kMsg object. 
 * @param   data       Message cotent. 
 * @return             Operation status. 
 */
kFsFx(kStatus) kMsg_SetData(kMsg msg, kObject data);

/** 
 * Gets the message content. 
 *
 * @public             @memberof kMsg
 * @param   msg        kMsg object. 
 * @return             Message cotent. 
 */
kInlineFx(kObject) kMsg_Data(kMsg msg)
{
    kObj(kMsg, msg); 

    return obj->data; 
}

#endif
