/** 
 * @file    kMovingAvg.h
 * @brief   Declares the kMovingAvg type. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_MOVING_AVG_H
#define K_FIRESYNC_MOVING_AVG_H

#include <kFireSync/kFsDef.h>

/**
 * @class   kMovingAvg
 * @extends kObject
 * @ingroup kFireSync-Data
 * @brief   Represents a runinng average calculation.
 */
//typedef kObject kMovingAvg;            --forward-declared in kFsDef.x.h  

/** 
 * Constructs a kMovingAvg object.
 *
 * @public              @memberof kMovingAvg
 * @param   stat        Destination for the constructed object handle. 
 * @param   window      Length of moving average (minimum 1). 
 * @param   allocator   Memory allocator (or kNULL for default). 
 * @return              Operation status. 
 */
kFsFx(kStatus) kMovingAvg_Construct(kMovingAvg* stat, kSize window, kAlloc allocator); 

/** 
 * Adds a sample value to the average. 
 *
 * @public              @memberof kMovingAvg
 * @param   stat        kMovingAvg object.  
 * @param   value       Value to add.   
 * @return              Operation status. 
 */
kFsFx(kStatus) kMovingAvg_Add(kMovingAvg stat, k64s value); 

/** 
 * Reports the current result of the running average calculation.
 *
 * @public              @memberof kMovingAvg
 * @param   stat        kMovingAvg object.  
 * @return              Current average. 
 */
kFsFx(k64s) kMovingAvg_Value(kMovingAvg stat); 

/** 
 * Reports the window size for the average calculation.
 *
 * @public              @memberof kMovingAvg
 * @param   stat        kMovingAvg object.  
 * @return              Window size.
 */
kFsFx(kSize) kMovingAvg_Window(kMovingAvg stat); 

/** 
 * Reports the current count of samples contributing to the average.
 *
 * @public              @memberof kMovingAvg
 * @param   stat        kMovingAvg object.  
 * @return              Sample count. 
 */
kFsFx(kSize) kMovingAvg_Count(kMovingAvg stat); 

#include <kFireSync/Data/kMovingAvg.x.h>

#endif
