/** 
 * @file    kNetInterface.x.h
 *
 * @internal
 * Copyright (C) 2018-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_NET_INTERFACE_X_H
#define K_FIRESYNC_NET_INTERFACE_X_H

typedef struct kNetInterfaceClass
{
    kObjectClass base; 

    kNode node;                                 //Node (hierarchy ancestor).
    kNet net;                                   //Net (hierarchy ancestor).
    kSize index; 

    kNetworkSpeed speedCapabilities;            //Network speed capabilities.
    kNetworkSpeed defaultSpeed;                 //Device default netInterfacework speed.
    kNetworkSpeed speed;                        //Current netInterfacework speed configuration.
    kNetworkSpeed nextSpeed;                    //Network speed after reboot.

    k32u txRate;                                //Network data transmission rate (percentage of maximum). 
    kBool txRateSupported;                      //Can the netInterfacework transmission rate be configured.  

    kIpConfig ipConfig;                         //Current IP configuration.
    kIpConfig nextIpConfig;                     //IP configuration after reboot (device config). 

    kMacAddress macAddress;                     //Current MAC address.

} kNetInterfaceClass; 

kDeclareClassEx(kFs, kNetInterface, kObject)
        
kFsFx(kStatus) kNetInterface_Construct(kNetInterface* netInterface, kNode node, kNet net, kSize index, kAlloc allocator);

kFsFx(kStatus) kNetInterface_Init(kNetInterface netInterface, kType type, kNode node, kNet net, kSize index, kAlloc alloc); 
kFsFx(kStatus) kNetInterface_VRelease(kNetInterface netInterface); 

kFsFx(kStatus) kNetInterface_ParseDevice(kNetInterface netInterface, kXml xml, kXmlItem item); 
kFsFx(kStatus) kNetInterface_FormatDevice(kNetInterface netInterface, kXml xml, kXmlItem item); 

kFsFx(kStatus) kNetInterface_Parse(kNetInterface netInterface, kXml xml, kXmlItem item); 
kFsFx(kStatus) kNetInterface_Format(kNetInterface netInterface, kXml xml, kXmlItem item); 

kFsFx(kStatus) kNetInterface_ClearEx(kNetInterface netInterface, kNodeClearOption options); 

kFsFx(kStatus) kNetInterface_Verify(kNetInterface netInterface); 

kFsFx(kNode) kNetInterface_Node(kNetInterface netInterface);
kFsFx(kSize) kNetInterface_Id(kNetInterface netInterface);

#endif
