/** 
 * @file    kActions.x.h
 *
 * @internal
 * Copyright (C) 2014-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_ACTIONS_X_H
#define K_FIRESYNC_ACTIONS_X_H

typedef struct kActionsClass
{
    kObjectClass base; 

    kNode node;                         //Node (hierarchy ancestor).

    kArrayList actionTypes;             //Action type information -- kArraylist<kActionTypeInfo>.    
    kArrayList actions;                 //Action instances -- kArrayList<kAction>.       
} kActionsClass; 

kDeclareClassEx(kFs, kActions, kObject)
        
kFsFx(kStatus) kActions_Construct(kActions* actions, kNode node, kAlloc allocator); 

kFsFx(kStatus) kActions_Init(kActions actions, kType type, kNode node, kAlloc alloc); 
kFsFx(kStatus) kActions_VRelease(kActions actions); 

kFsFx(kStatus) kActions_Parse(kActions actions, kXml xml, kXmlItem item); 
kFsFx(kStatus) kActions_ParseTypes(kActions actions, kXml xml, kXmlItem item); 
kFsFx(kStatus) kActions_ParseActions(kActions actions, kXml xml, kXmlItem item); 

kFsFx(kStatus) kActions_Format(kActions actions, kXml xml, kXmlItem item); 
kFsFx(kStatus) kActions_FormatActions(kActions actions, kXml xml, kXmlItem item, const kChar* itemName); 

kFsFx(kStatus) kActions_VerificationLabel(kActions actions, kChar* label, kSize capacity); 
kFsFx(kStatus) kActions_Verify(kActions actions); 

kFsFx(kStatus) kActions_ClearEx(kActions actions, kNodeClearOption options); 

#endif
