/** 
 * @file    kAction.x.h
 *
 * @internal
 * Copyright (C) 2014-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_ACTION_X_H
#define K_FIRESYNC_ACTION_X_H

#define kACTION_CONFIG_VERSION              (1)              //Action config format version

typedef struct kActionClass
{
    kObjectClass base; 

    kNode node;                     //Node (hierarchy ancestor).
    kActions actions;               //Actions collection to which action belongs. 

    kText32 name;                   //Descriptive instance name. 
    kText32 typeName;               //Remote action type name. 
    kText256 description;           //Description of action type.
    kActionTrigger triggerType;     //Action trigger type.

    kXml settings;                  //Custom settings. 
   
} kActionClass; 

kDeclareClassEx(kFs, kAction, kObject)
        
kFsFx(kStatus) kAction_Construct(kAction* action, kNode node, kActions actions, kAlloc allocator); 

kFsFx(kStatus) kAction_Init(kAction action, kType type, kNode node, kActions actions, kAlloc alloc); 
kFsFx(kStatus) kAction_VRelease(kAction action); 

kFsFx(kStatus) kAction_Parse(kAction action, kXml xml, kXmlItem item); 

kFsFx(kStatus) kAction_Format(kAction action, kXml xml, kXmlItem item); 

kFsFx(kStatus) kAction_VerificationLabel(kAction action, kChar* label, kSize capacity); 
kFsFx(kStatus) kAction_Verify(kAction action); 

kFsFx(kStatus) kAction_Validate(kAction action); 

kFsFx(kStatus) kAction_SetActions(kAction action, kActions actions);
kFsFx(kStatus) kAction_SetTypeName(kAction action, const kChar* typeName);

#endif

