/** 
 * @file    kDp01Info.h
 * @brief   Declares the kDp01Info class and related types. 
 *
 * @internal
 * Copyright (C) 2015-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_DP01_INFO_H
#define K_FIRESYNC_DP01_INFO_H

#include <kFireSync/Client/Projector/kProjectorInfo.h>

/**
 * @internal
 * @class   kDp01Info
 * @extends kProjectorInfo
 * @ingroup kFireSync-Client-Projector
 * @brief   Represents information about the DP01 projector model. 
 */
//typedef kProjectorInfo kDp01Info;             --forward-declared in kFsDef.x.h

/** 
 * Constructs a kDp01Info object.
 *
 * @public              @memberof kDp01Info
 * @param   info        Destination for the constructed object handle. 
 * @param   allocator   Memory allocator (or kNULL for default). 
 * @return              Operation status. 
 */
kFsFx(kStatus) kDp01Info_Construct(kDp01Info* info, k64f pixelClockFrequency, kAlloc allocator);

#include <kFireSync/Client/Projector/kDp01Info.x.h>

#endif
