/** 
 * @file    kProjectorSteps.h
 * @brief   Declares the kProjectorSteps type. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_PROJECTOR_STEPS_H
#define K_FIRESYNC_PROJECTOR_STEPS_H

#include <kFireSync/Client/Projector/Extensions/kProjectorExt.h>

/**
 * @class   kProjectorSteps
 * @extends kProjectorExt
 * @ingroup kFireSync-Client-Projector-Extensions
 * @brief   Represents parameters for the projector steps extension. 
 */
//typedef kProjectorExt kProjectorSteps;            --forward-declared in kFsDef.x.h

/** 
 * Sets the number of steps (state/count pairs) defined by this extension. 
 *
 * @public              @memberof kProjectorSteps
 * @param   extension    Sequence object. 
 * @param   count       Step count. 
 * @return              Operation status. 
 */
kFsFx(kStatus) kProjectorSteps_SetCount(kProjectorSteps extension, kSize count); 

/** 
 * Gets the number of steps (state/count pairs) defined by this extension. 
 *
 * @public              @memberof kProjectorSteps
 * @param   extension    Sequence object. 
 * @return              Step count. 
 */
kFsFx(kSize) kProjectorSteps_Count(kProjectorSteps extension); 

/** 
 * Reports constraint and validity information for the Count setting. 
 *
 * @public              @memberof kProjectorSteps
 * @param   extension    Sequence object. 
 * @param   info        Receives the info structure.  
 * @return              Operation status. 
 */
kFsFx(kStatus) kProjectorSteps_CountInfo(kProjectorSteps extension, kInfoSize* info); 

/** 
 * Sets the projector state id (index) associated with the specified step index. 
 *
 * @public              @memberof kProjectorSteps
 * @param   extension    Sequence object. 
 * @param   stepIndex   Step index. 
 * @param   stateIndex  Projector state id/index. 
 * @return              Operation status. 
 */
kFsFx(kStatus) kProjectorSteps_SetState(kProjectorSteps extension, kSize stepIndex, kSize stateIndex); 

/** 
 * Gets the projector state id (index) associated with the specified step index. 
 *
 * @public              @memberof kProjectorSteps
 * @param   extension    Sequence object. 
 * @param   stepIndex   Step index. 
 * @return              Projector state id/index.
 */
kFsFx(kSize) kProjectorSteps_State(kProjectorSteps extension, kSize stepIndex); 

/** 
 * Sets the repetition count associated with the specified step index. 
 *
 * @public              @memberof kProjectorSteps
 * @param   extension    Sequence object. 
 * @param   stepIndex   Step index. 
 * @param   count       Repetition count. 
 * @return              Operation status. 
 */
kFsFx(kStatus) kProjectorSteps_SetRepetitionCount(kProjectorSteps extension, kSize stepIndex, kSize count); 

/** 
 * Gets the repetition count associated with the specified step index. 
 *
 * @public              @memberof kProjectorSteps
 * @param   extension    Sequence object. 
 * @param   stepIndex   Step index. 
 * @return              Repetition count. 
 */
kFsFx(kSize) kProjectorSteps_RepetitionCount(kProjectorSteps extension, kSize stepIndex); 

/**
* Sets the steps style.
*
* @public              @memberof kProjectorSteps
* @param   extension   Sequence object.
* @param   style       Steps style.
* @return              Operation status.
*/
kFsFx(kStatus) kProjectorSteps_SetStyle(kProjectorSteps extension, kProjectorStepsStyle style);

/**
* Gets the steps style.
*
* @public              @memberof kProjectorSteps
* @param   extension   Extension object.
* @return              Steps style.
*/
kFsFx(kProjectorStepsStyle) kProjectorSteps_Style(kProjectorSteps extension);

/**
* Reports constraint and validity information for the Steps style setting.
*
* @public              @memberof kProjectorSteps
* @param   extension   Extension object.
* @param   info        Receives the info structure.
* @return              Operation status.
*/
kFsFx(kStatus) kProjectorSteps_StyleInfo(kProjectorSteps extension, kInfoBits* info);

#include <kFireSync/Client/Projector/Extensions/kProjectorSteps.x.h>

#endif
