/** 
 * @file    kNodeProvider.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_NODE_PROVIDER_X_H
#define K_FIRESYNC_NODE_PROVIDER_X_H

typedef struct kNodeProviderVTable
{   
    kStatus (kCall* VIsRemote)(kNodeProvider provider); 

    kStatus (kCall* VSetErrorHandler)(kNodeProvider provider, kCallbackFx function, kPointer receiver);
    kStatus (kCall* VSetCancelHandler)(kNodeProvider provider, kCallbackFx function, kPointer receiver);
    kStatus (kCall* VSetProtocolVersion)(kNodeProvider provider, kVersion protocol, kVersion platform);
    kStatus (kCall* VBeginOpenControl)(kNodeProvider provider); 
    kStatus (kCall* VEndOpenControl)(kNodeProvider provider); 
    kStatus (kCall* VCloseControl)(kNodeProvider provider); 
    kStatus (kCall* VSetHealthHandler)(kNodeProvider provider, kCallbackFx function, kPointer receiver);
    kStatus (kCall* VBeginOpenHealth)(kNodeProvider provider); 
    kStatus (kCall* VEndOpenHealth)(kNodeProvider provider); 
    kStatus (kCall* VCloseHealth)(kNodeProvider provider); 
    kStatus (kCall* VSetDataBufferSize)(kNodeProvider provider, kSize size);
    kStatus (kCall* VSetDataHandler)(kNodeProvider provider, kCallbackFx function, kPointer receiver);
    kStatus (kCall* VBeginOpenData)(kNodeProvider provider, const k16u* ports, kSize portCount); 
    kStatus (kCall* VEndOpenData)(kNodeProvider provider); 
    kStatus (kCall* VEndDataSession)(kNodeProvider provider);
    kStatus (kCall* VCloseData)(kNodeProvider provider);
    kStatus (kCall* VInvalidateDataSession)(kNodeProvider provider);

    kStatus (kCall* VClearFirmware)(kNodeProvider provider, kNodeFirmwareType type); 
    kStatus (kCall* VWriteFirmware)(kNodeProvider provider, kNodeFirmwareType type, kStream stream, kSize size, kCallbackFx progress, kPointer context); 
    kStatus (kCall* VReloadFirmware)(kNodeProvider provider, kNodeFirmwareType type, kStream stream, kSize size);
    kStatus (kCall* VReset)(kNodeProvider provider, kBool restartApp);

    kStatus (kCall* VChangeAddressAndReset)(kNodeProvider provider, kSize nodeInterfaceIndex, const kIpConfig* config); 
 
    kStatus (kCall* VWriteFile)(kNodeProvider provider, const kChar* path, kStream stream, kSize size, kCallbackFx progress, kPointer context); 
    kStatus (kCall* VCopyFile)(kNodeProvider provider, const kChar* sourcePath, const kChar* destPath, kCallbackFx progress, kPointer context); 
    kStatus (kCall* VReadFile)(kNodeProvider provider, const kChar* path, kStream stream, kCallbackFx progress, kPointer context); 
    kStatus (kCall* VDeleteFile)(kNodeProvider provider, const kChar* path); 
    kStatus (kCall* VGetFileInfo)(kNodeProvider provider, const kChar* path, kStorageItem* item);
    kStatus (kCall* VCreateDirectory)(kNodeProvider provider, const kChar* path); 
    kStatus (kCall* VDeleteDirectory)(kNodeProvider provider, const kChar* path); 
    kStatus (kCall* VListDirectoryEntries)(kNodeProvider provider, const kChar* path, kBool includeFiles, kBool includeDirectories, kArrayList entries); 
    kStatus (kCall* VListDirectoryEntriesEx)(kNodeProvider provider, const kChar* path, kArrayList entries); 

    kStatus (kCall* VSetDeviceConfig)(kNodeProvider provider, kXml xml, k64u revisionId); 
    kStatus (kCall* VGetDeviceConfig)(kNodeProvider provider, kXml xml, k64u* revisionId); 
    kStatus (kCall* VCommitDeviceConfig)(kNodeProvider provider); 
    kStatus (kCall* VSetModeConfig)(kNodeProvider provider, kXml xml, k64u revisionId); 
    kStatus (kCall* VGetModeConfig)(kNodeProvider provider, kXml xml, k64u* revisionId); 
    kStatus (kCall* VSaveModeConfig)(kNodeProvider provider, const kChar* path); 
    kStatus (kCall* VLoadModeConfig)(kNodeProvider provider, const kChar* path); 
    kStatus (kCall* VCommitModeConfig)(kNodeProvider provider); 
    kStatus (kCall* VValidateBlockConfig)(kNodeProvider provider, kXml config); 

    kStatus (kCall* VSetDateTime)(kNodeProvider provider, kDateTime dateTime, kBool isAuthoritative); 
    kStatus (kCall* VIncrementInputCounter)(kNodeProvider provider);

    kStatus (kCall* VCameraOverride)(kNodeProvider provider, kSize index, const kCameraOverrideItem* overrides, kSize count);
    kStatus (kCall* VLightOverride)(kNodeProvider provider, kSize index, const kLightOverrideItem* overrides, kSize count);

    kStatus (kCall* VListProcedures)(kNodeProvider provider, kArrayList procedures);    
    kStatus (kCall* VInvokeProcedure)(kNodeProvider provider, const kChar* name, kObject input, kObject* output, kAlloc alloc);    

    kStatus (kCall* VSetVariable)(kNodeProvider provider, const kChar* name, kObject variable); 
    kStatus (kCall* VGetVariable)(kNodeProvider provider, const kChar* name, kObject* variable, kAlloc alloc); 
    kStatus (kCall* VGetVariableInfo)(kNodeProvider provider, const kChar* name, kNodeVariableInfo* info); 
    kStatus (kCall* VDeleteVariable)(kNodeProvider provider, const kChar* name); 
    kStatus (kCall* VListVariables)(kNodeProvider provider, kArrayList variables); 

    kStatus (kCall* VValidateActionConfig)(kNodeProvider provider, kXml config); 
    kStatus (kCall* VInvokeAction)(kNodeProvider provider, const kChar* typeName, kXml config, kObject input, kObject* output, kAlloc alloc); 
    kStatus (kCall* VInvokeNamedAction)(kNodeProvider provider, const kChar* name, kObject input, kObject* output, kAlloc alloc); 

    kStatus (kCall* VReadMemory)(kNodeProvider provider, kNodeMemorySpace space, k64u offset, kSize length, void* data);
    kStatus (kCall* VWriteMemory)(kNodeProvider provider, kNodeMemorySpace space, k64u offset, kSize length, const void* data);

    kStatus (kCall* VReadRegisters)(kNodeProvider provider, kRegisterModule moduleType, kSize moduleIndex, kArrayList registers); 
    kStatus (kCall* VReadRegisterOverrides)(kNodeProvider provider, kRegisterModule moduleType, kArrayList registers); 
    kStatus (kCall* VWriteRegisterOverrides)(kNodeProvider provider, kRegisterModule moduleType, kArrayList registers); 

    kStatus (kCall* VI2cRead)(kNodeProvider provider, k32u deviceId, k32u address, kByte* data, kSize size);
    kStatus (kCall* VI2cWrite)(kNodeProvider provider, k32u deviceId, k32u address, const kByte* data, kSize size);

    kStatus (kCall* VBeginSpi)(kNodeProvider provider, kSpiDeviceType type);
    kStatus (kCall* VEndSpi)(kNodeProvider provider);
    kStatus (kCall* VSpiRead)(kNodeProvider provider, kByte* opCode, kSize opSize, kByte* data, kSize dataSize);
    kStatus (kCall* VSpiWrite)(kNodeProvider provider, kByte* opCode, kSize opSize, kByte* data, kSize dataSize);

    kStatus (kCall* VReadLogHistory)(kNodeProvider provider, kArrayList logItems); 
    kStatus (kCall* VReadCrashLog)(kNodeProvider provider, kString* crashLog, kAlloc allocator); 
    kStatus (kCall* VClearCrashLog)(kNodeProvider provider); 

    kStatus (kCall* VBeginStart)(kNodeProvider provider); 
    kStatus (kCall* VEndStart)(kNodeProvider provider); 
    kStatus (kCall* VBeginStop)(kNodeProvider provider, kBool synchronizeData); 
    kStatus (kCall* VEndStop)(kNodeProvider provider); 
    kStatus (kCall* VBeginEngage)(kNodeProvider provider, k64u startTime, k64s startEncoder); 
    kStatus (kCall* VEndEngage)(kNodeProvider provider); 

    kStatus (kCall* VBeginStartReplay)(kNodeProvider provider); 
    kStatus (kCall* VEndStartReplay)(kNodeProvider provider); 
    kStatus (kCall* VReplay)(kNode node, kObject input, kArrayList output); 

    kStatus (kCall* VScheduleEvent)(kNodeProvider provider, k32u eventManagerId, k64s target);    
    kStatus (kCall* VTriggerEvent)(kNodeProvider provider, k32u eventManagerId);  
    kStatus (kCall* VTriggerCamera)(kNodeProvider provider, kSize index);
    kStatus (kCall* VTriggerLight)(kNodeProvider provider, kSize index);
    kStatus (kCall* VSetLightState)(kNodeProvider provider, kSize index, kBool enabled); 
    kStatus (kCall* VSetDigitalOutState)(kNodeProvider provider, kSize index, kBool state);
    kStatus (kCall* VTriggerDigitalOut)(kNodeProvider provider, kSize index);
    kStatus (kCall* VEnqueueAnalogOut)(kNodeProvider provider, kSize index, k32u value);
    kStatus (kCall* VEnqueueAnalogOutCurrent)(kNodeProvider provider, kSize index, k64f current);
    kStatus (kCall* VWriteAnalogOutCalibration)(kNodeProvider provider, kSize index, kArray2 calibration, k64u revisionId);
    kStatus (kCall* VWriteSerialOut)(kNodeProvider provider, kSize index, const void* buffer, kSize size);

    kStatus (kCall* VWriteRamImage)(kNodeProvider provider, kSize index, kSize stateIndex, kSize imageIndex, kImage image);
    kStatus (kCall* VWritePrnu)(kNodeProvider provider, kSize index, kImage white, kImage black);
    kStatus (kCall* VWriteFpn)(kNodeProvider provider, kSize index, kImage offsets);
    kStatus (kCall* VWriteRangeLut)(kNodeProvider provider, kSize index, const kRangeLutParams* params, const kRangeLutArray* xArray, 
                                          const kRangeLutArray* zArray, const kRangeLutArray* validArray);
    kStatus (kCall* VWritePhaseDecoderLut)(kNodeProvider provider, kSize index, kCameraPhaseDecoderLutType type, kArray1 lut);
    kStatus (kCall* VSetCameraLvdsPower)(kNodeProvider provider, kSize index, k32u power);
    kStatus (kCall* VGetCameraLvdsPower)(kNodeProvider provider, kSize index, k32u *power);
    kStatus (kCall* VWriteAccelerationTestData)(kNodeProvider provider, kSize index, kObject object);
    kStatus (kCall* VReadAccelerationTestResult)(kNodeProvider provider, kSize index, kObject* object, kAlloc allocator);

    kStatus (kCall* VLoadPatterns)(kNodeProvider provider, kSize index, kArray2 patterns);
    kStatus (kCall* VLoadProjectorRowGains)(kNodeProvider provider, kSize index, kArray1 gains);
    kStatus (kCall* VLoadProjectorColGains)(kNodeProvider provider, kSize index, kArray1 gains);
    kStatus (kCall* VResetEncoder)(kNodeProvider provider);
    kStatus (kCall* VEnableLed)(kNodeProvider provider, kLed instance, kBool enabled);
    kStatus (kCall* VSetLedMode)(kNodeProvider provider, kLed instance, kLedMode mode);
    kStatus (kCall* VSetGpioState)(kNodeProvider provider, kSize bankIndex, k64u mask, k64u state);
    kStatus (kCall* VGetGpioState)(kNodeProvider provider, kSize bankIndex, k64u* state);

    kStatus (kCall* VGetInfo)(kNodeProvider provider, kNodeInfo* info); 
    kStatus (kCall* VGetState)(kNodeProvider provider, kNodeStateInfo* info); 
    kStatus (kCall* VGetHealth)(kNodeProvider provider, kArrayList stats); 
    kStatus (kCall* VReadHealthLog)(kNodeProvider provider, kHealthSummary* summary, kAlloc alloc); 
    kStatus (kCall* VClearHealthLog)(kNodeProvider provider);  
    kStatus (kCall* VGetNodeStats)(kNodeProvider provider, kNodeStats* stats);    
    kStatus (kCall* VGetEventStats)(kNodeProvider provider, k32u eventManagerId, kEventStats* stats);    
    kStatus (kCall* VGetCameraStats)(kNodeProvider provider, kSize index, kCameraStats* stats);
    kStatus (kCall* VGetLightStats)(kNodeProvider provider, kSize index, kLightStats* stats);
    kStatus (kCall* VGetProjectorStats)(kNodeProvider provider, kSize index, kProjectorStats* stats);
    kStatus (kCall* VGetAnalogOutStats)(kNodeProvider provider, kSize index, kAnalogOutStats* stats);
    kStatus (kCall* VGetDigitalOutStats)(kNodeProvider provider, kSize index, kDigitalOutStats* stats);
    kStatus (kCall* VGetSerialOutStats)(kNodeProvider provider, kSize index, kSerialOutStats* stats);

    kStatus (kCall* VResetIoTest)(kNodeProvider provider, kSize index);
    kStatus (kCall* VGetIoTestStats)(kNodeProvider provider, kSize index, kIoTestStats* stats);
    kStatus (kCall* VReadIoTestSerialData)(kNodeProvider provider, kSize index, void* buffer, kSize capacity, kSize* bytesRead);

    kStatus (kCall* VTestJigCommand)(kNodeProvider provider, kTestJigCommand command, k64u data);
    kStatus (kCall* VGetTestJigStats)(kNodeProvider provider, kTestJigStats* stats);

    kStatus (kCall* VLockOutLight)(kNodeProvider provider, kSize index, kBool shouldLock);
    kStatus (kCall* VSetLightDriverPower)(kNodeProvider provider, kSize index, k64u key, k32u power, kBool commit);
    kStatus (kCall* VGetLightDriverPower)(kNodeProvider provider, kSize index, k64u key, k32u* power);
    kStatus (kCall* VSetLightDriverCurrentLimit)(kNodeProvider provider, kSize index, k64u key, k32u currentLimit, kBool commit);
    kStatus (kCall* VGetLightDriverCurrentLimit)(kNodeProvider provider, kSize index, k64u key, k32u* currentLimit);
    kStatus (kCall* VGetLightDriverRemainingSlotCount)(kNodeProvider provider, kSize index, k64u key, kSize* remainingCount);
    kStatus (kCall* VSetLightDriverInfo)(kNodeProvider provider, kSize index, k64u key, kLightModel model, kVersion revision, k32u deviceId);
    kStatus (kCall* VGetLightDriverInfo)(kNodeProvider provider, kSize index, k64u key, kLightModel* model, kVersion* revision, k32u* deviceId);
    kStatus (kCall* VSetLightDriverCalibration)(kNodeProvider provider, kSize index, k64u key, kDataTree ldCal, kBool commit);
    kStatus (kCall* VGetLightDriverCalibration)(kNodeProvider provider, kSize index, k64u key, kDataTree* ldCal, kAlloc alloc);
    kStatus (kCall* VSetLightDriverControl)(kNodeProvider provider, kSize index, k64u key, kBool enabled);
    kStatus (kCall* VGetLightDriverControl)(kNodeProvider provider, kSize index, k64u key, kBool* enabled);
    kStatus (kCall* VReadLightDriverTemperature)(kNodeProvider provider, kSize index, k64u key, k32s* temperature);

    kStatus(kCall* VStartOrientationCalibration)(kNodeProvider provider);
    kStatus(kCall* VGetOrientationStats)(kNodeProvider provider, kOrientationStats* stats);

} kNodeProviderVTable;

kDeclareInterfaceEx(kFs, kNodeProvider, kNull) 

kFsFx(kBool) kNodeProvider_VIsRemote(kNodeProvider provider); 

kFsFx(kStatus) kNodeProvider_VSetErrorHandler(kNodeProvider provider, kCallbackFx function, kPointer receiver); 
kFsFx(kStatus) kNodeProvider_VSetCancelHandler(kNodeProvider provider, kCallbackFx function, kPointer receiver); 
kFsFx(kStatus) kNodeProvider_VSetProtocolVersion(kNodeProvider provider, kVersion protocol, kVersion platform); 
kFsFx(kStatus) kNodeProvider_VBeginOpenControl(kNodeProvider provider); 
kFsFx(kStatus) kNodeProvider_VEndOpenControl(kNodeProvider provider); 
kFsFx(kStatus) kNodeProvider_VCloseControl(kNodeProvider provider); 
kFsFx(kStatus) kNodeProvider_VSetHealthHandler(kNodeProvider provider, kCallbackFx function, kPointer receiver);
kFsFx(kStatus) kNodeProvider_VBeginOpenHealth(kNodeProvider provider); 
kFsFx(kStatus) kNodeProvider_VEndOpenHealth(kNodeProvider provider); 
kFsFx(kStatus) kNodeProvider_VCloseHealth(kNodeProvider provider); 
kFsFx(kStatus) kNodeProvider_VSetDataBufferSize(kNodeProvider provider, kSize size);
kFsFx(kStatus) kNodeProvider_VSetDataHandler(kNodeProvider provider, kCallbackFx function, kPointer receiver);
kFsFx(kStatus) kNodeProvider_VBeginOpenData(kNodeProvider provider, const k16u* ports, kSize portCount); 
kFsFx(kStatus) kNodeProvider_VEndOpenData(kNodeProvider provider); 
kFsFx(kStatus) kNodeProvider_VEndDataSession(kNodeProvider provider);
kFsFx(kStatus) kNodeProvider_VCloseData(kNodeProvider provider);
kFsFx(kStatus) kNodeProvider_VInvalidateDataSession(kNodeProvider provider);

kFsFx(kStatus) kNodeProvider_VClearFirmware(kNodeProvider provider, kNodeFirmwareType type); 
kFsFx(kStatus) kNodeProvider_VWriteFirmware(kNodeProvider provider, kNodeFirmwareType type, kStream stream, kSize size, kCallbackFx progress, kPointer context); 
kFsFx(kStatus) kNodeProvider_VReloadFirmware(kNodeProvider provider, kNodeFirmwareType type, kStream stream, kSize size);
kFsFx(kStatus) kNodeProvider_VReset(kNodeProvider provider, kBool restartApp); 

kFsFx(kStatus) kNodeProvider_VChangeAddressAndReset(kNodeProvider provider, kSize nodeInterfaceIndex, const kIpConfig* config); 

kFsFx(kStatus) kNodeProvider_VWriteFile(kNodeProvider provider, const kChar* path, kStream stream, kSize size, kCallbackFx progress, kPointer context); 
kFsFx(kStatus) kNodeProvider_VCopyFile(kNodeProvider provider, const kChar* sourcePath, const kChar* destPath, kCallbackFx progress, kPointer context); 
kFsFx(kStatus) kNodeProvider_VReadFile(kNodeProvider provider, const kChar* path, kStream stream, kCallbackFx progress, kPointer context); 
kFsFx(kStatus) kNodeProvider_VDeleteFile(kNodeProvider provider, const kChar* path); 
kFsFx(kStatus) kNodeProvider_VGetFileInfo(kNodeProvider provider, const kChar* path, kStorageItem* item);
kFsFx(kStatus) kNodeProvider_VCreateDirectory(kNodeProvider provider, const kChar* path); 
kFsFx(kStatus) kNodeProvider_VDeleteDirectory(kNodeProvider provider, const kChar* path); 
kFsFx(kStatus) kNodeProvider_VListDirectoryEntries(kNodeProvider provider, const kChar* path, kBool includeFiles, kBool includeDirectories, kArrayList entries); 
kFsFx(kStatus) kNodeProvider_VListDirectoryEntriesEx(kNodeProvider provider, const kChar* path, kArrayList entries); 

kFsFx(kStatus) kNodeProvider_VSetDeviceConfig(kNodeProvider provider, kXml xml, k64u revisionId); 
kFsFx(kStatus) kNodeProvider_VGetDeviceConfig(kNodeProvider provider, kXml xml, k64u* revisionId); 
kFsFx(kStatus) kNodeProvider_VCommitDeviceConfig(kNodeProvider provider); 
kFsFx(kStatus) kNodeProvider_VSetModeConfig(kNodeProvider provider, kXml xml, k64u revisionId); 
kFsFx(kStatus) kNodeProvider_VGetModeConfig(kNodeProvider provider, kXml xml, k64u* revisionId); 
kFsFx(kStatus) kNodeProvider_VSaveModeConfig(kNodeProvider provider, const kChar* path); 
kFsFx(kStatus) kNodeProvider_VLoadModeConfig(kNodeProvider provider, const kChar* path); 
kFsFx(kStatus) kNodeProvider_VCommitModeConfig(kNodeProvider provider); 
kFsFx(kStatus) kNodeProvider_VValidateBlockConfig(kNodeProvider provider, kXml xml);

kFsFx(kStatus) kNodeProvider_VSetDateTime(kNodeProvider provider, kDateTime dateTime, kBool isAuthoritative); 
kFsFx(kStatus) kNodeProvider_VIncrementInputCounter(kNodeProvider provider);

kFsFx(kStatus) kNodeProvider_VCameraOverride(kNodeProvider provider, kSize index, const kCameraOverrideItem* overrides, kSize count);
kFsFx(kStatus) kNodeProvider_VLightOverride(kNodeProvider provider, kSize index, const kLightOverrideItem* overrides, kSize count);

kFsFx(kStatus) kNodeProvider_VListProcedures(kNodeProvider provider, kArrayList procedures);    
kFsFx(kStatus) kNodeProvider_VInvokeProcedure(kNodeProvider provider, const kChar* name, kObject input, kObject* output, kAlloc alloc);    

kFsFx(kStatus) kNodeProvider_VSetVariable(kNodeProvider provider, const kChar* name, kObject variable); 
kFsFx(kStatus) kNodeProvider_VGetVariable(kNodeProvider provider, const kChar* name, kObject* variable, kAlloc alloc); 
kFsFx(kStatus) kNodeProvider_VGetVariableInfo(kNodeProvider provider, const kChar* name, kNodeVariableInfo* info); 
kFsFx(kStatus) kNodeProvider_VDeleteVariable(kNodeProvider provider, const kChar* name); 
kFsFx(kStatus) kNodeProvider_VListVariables(kNodeProvider provider, kArrayList variables); 

kFsFx(kStatus) kNodeProvider_VValidateActionConfig(kNodeProvider provider, kXml config); 
kFsFx(kStatus) kNodeProvider_VInvokeAction(kNodeProvider provider, const kChar* typeName, kXml config, kObject input, kObject* output, kAlloc alloc); 
kFsFx(kStatus) kNodeProvider_VInvokeNamedAction(kNodeProvider provider, const kChar* name, kObject input, kObject* output, kAlloc alloc); 

kFsFx(kStatus) kNodeProvider_VReadMemory(kNodeProvider provider, kNodeMemorySpace space, k64u offset, kSize length, void* data);
kFsFx(kStatus) kNodeProvider_VWriteMemory(kNodeProvider provider, kNodeMemorySpace space, k64u offset, kSize length, const void* data);

kFsFx(kStatus) kNodeProvider_VReadRegisters(kNodeProvider provider, kRegisterModule moduleType, kSize moduleIndex, kArrayList registers);
kFsFx(kStatus) kNodeProvider_VReadRegisterOverrides(kNodeProvider provider, kRegisterModule moduleType, kArrayList registers);
kFsFx(kStatus) kNodeProvider_VWriteRegisterOverrides(kNodeProvider provider, kRegisterModule moduleType, kArrayList registers);

kFsFx(kStatus) kNodeProvider_VI2cRead(kNodeProvider provider, k32u deviceId, k32u address, kByte* data, kSize size);
kFsFx(kStatus) kNodeProvider_VI2cWrite(kNodeProvider provider, k32u deviceId, k32u address, const kByte* data, kSize size);

kFsFx(kStatus) kNodeProvider_VBeginSpi(kNodeProvider provider, kSpiDeviceType type);
kFsFx(kStatus) kNodeProvider_VEndSpi(kNodeProvider provider);
kFsFx(kStatus) kNodeProvider_VSpiRead(kNodeProvider provider, kByte* opCode, kSize opSize, kByte* data, kSize dataSize);
kFsFx(kStatus) kNodeProvider_VSpiWrite(kNodeProvider provider, kByte* opCode, kSize opSize, kByte* data, kSize dataSize);

kFsFx(kStatus) kNodeProvider_VReadLogHistory(kNodeProvider provider, kArrayList logItems);
kFsFx(kStatus) kNodeProvider_VReadCrashLog(kNodeProvider provider, kString* crashLog, kAlloc allocator);
kFsFx(kStatus) kNodeProvider_VClearCrashLog(kNodeProvider provider);

kFsFx(kStatus) kNodeProvider_VBeginStart(kNodeProvider provider); 
kFsFx(kStatus) kNodeProvider_VEndStart(kNodeProvider provider); 
kFsFx(kStatus) kNodeProvider_VBeginStop(kNodeProvider provider, kBool synchronizeData); 
kFsFx(kStatus) kNodeProvider_VEndStop(kNodeProvider provider); 
kFsFx(kStatus) kNodeProvider_VBeginEngage(kNodeProvider provider, k64u startTime, k64s startEncoder); 
kFsFx(kStatus) kNodeProvider_VEndEngage(kNodeProvider provider); 

kFsFx(kStatus) kNodeProvider_VBeginStartReplay(kNodeProvider provider);
kFsFx(kStatus) kNodeProvider_VEndStartReplay(kNodeProvider provider);
kFsFx(kStatus) kNodeProvider_VReplay(kNodeProvider provider, kObject input, kArrayList output);

kFsFx(kStatus) kNodeProvider_VScheduleEvent(kNodeProvider provider, k32u eventManagerId, k64s target);    
kFsFx(kStatus) kNodeProvider_VTriggerEvent(kNodeProvider provider, k32u eventManagerId);   
kFsFx(kStatus) kNodeProvider_VTriggerCamera(kNodeProvider provider, kSize index);
kFsFx(kStatus) kNodeProvider_VSetLightState(kNodeProvider provider, kSize index, kBool enabled);
kFsFx(kStatus) kNodeProvider_VTriggerLight(kNodeProvider provider, kSize index);
kFsFx(kStatus) kNodeProvider_VSetDigitalOutState(kNodeProvider provider, kSize index, kBool state);
kFsFx(kStatus) kNodeProvider_VTriggerDigitalOut(kNodeProvider provider, kSize index);
kFsFx(kStatus) kNodeProvider_VEnqueueAnalogOut(kNodeProvider provider, kSize index, k32u value);
kFsFx(kStatus) kNodeProvider_VEnqueueAnalogOutCurrent(kNodeProvider provider, kSize index, k64f current);
kFsFx(kStatus) kNodeProvider_VWriteAnalogOutCalibration(kNodeProvider provider, kSize index, kArray2 calibration, k64u revisionId);
kFsFx(kStatus) kNodeProvider_VWriteSerialOut(kNodeProvider provider, kSize index, const void* buffer, kSize size);
kFsFx(kStatus) kNodeProvider_VWriteRamImage(kNodeProvider provider, kSize index, kSize stateIndex, kSize imageIndex, kImage image);
kFsFx(kStatus) kNodeProvider_VWritePrnu(kNodeProvider provider, kSize index, kImage white, kImage black);
kFsFx(kStatus) kNodeProvider_VWriteFpn(kNodeProvider provider, kSize index, kImage offsets);
kFsFx(kStatus) kNodeProvider_VWriteRangeLut(kNodeProvider provider, kSize index, const kRangeLutParams* params, const kRangeLutArray* xArray,
                                            const kRangeLutArray* zArray, const kRangeLutArray* validArray);
kFsFx(kStatus) kNodeProvider_VWritePhaseDecoderLut(kNodeProvider provider, kSize index, kCameraPhaseDecoderLutType type, kArray1 lut);
kFsFx(kStatus) kNodeProvider_VSetCameraLvdsPower(kNodeProvider provider, kSize index, k32u power);
kFsFx(kStatus) kNodeProvider_VGetCameraLvdsPower(kNodeProvider provider, kSize index, k32u* power);
kFsFx(kStatus) kNodeProvider_VWriteAccelerationTestData(kNodeProvider provider, kSize index, kObject data);
kFsFx(kStatus) kNodeProvider_VReadAccelerationTestResult(kNodeProvider provider, kSize index, kObject* data, kAlloc allocator);

kFsFx(kStatus) kNodeProvider_VLoadPatterns(kNodeProvider provider, kSize index, kArray2 patterns);
kFsFx(kStatus) kNodeProvider_VLoadProjectorRowGains(kNodeProvider provider, kSize index, kArray1 gains);
kFsFx(kStatus) kNodeProvider_VLoadProjectorColGains(kNodeProvider provider, kSize index, kArray1 gains);
kFsFx(kStatus) kNodeProvider_VResetEncoder(kNodeProvider provider);
kFsFx(kStatus) kNodeProvider_VEnableLed(kNodeProvider provider, kLed instance, kBool enabled);
kFsFx(kStatus) kNodeProvider_VSetLedMode(kNodeProvider provider, kLed instance, kLedMode mode);
kFsFx(kStatus) kNodeProvider_VSetGpioState(kNodeProvider provider, kSize bankIndex, k64u mask, k64u state);
kFsFx(kStatus) kNodeProvider_VGetGpioState(kNodeProvider provider, kSize bankIndex, k64u* state);

kFsFx(kStatus) kNodeProvider_VGetInfo(kNodeProvider provider, kNodeInfo* info); 
kFsFx(kStatus) kNodeProvider_VGetState(kNodeProvider provider, kNodeStateInfo* info); 
kFsFx(kStatus) kNodeProvider_VGetHealth(kNodeProvider provider, kArrayList stats); 
kFsFx(kStatus) kNodeProvider_VReadHealthLog(kNodeProvider provider, kHealthSummary* summary, kAlloc alloc); 
kFsFx(kStatus) kNodeProvider_VClearHealthLog(kNodeProvider provider);  
kFsFx(kStatus) kNodeProvider_VGetNodeStats(kNodeProvider provider, kNodeStats* stats);    
kFsFx(kStatus) kNodeProvider_VGetEventStats(kNodeProvider provider, k32u eventManagerId, kEventStats* stats);    
kFsFx(kStatus) kNodeProvider_VGetCameraStats(kNodeProvider provider, kSize index, kCameraStats* stats);
kFsFx(kStatus) kNodeProvider_VGetLightStats(kNodeProvider provider, kSize index, kLightStats* stats);
kFsFx(kStatus) kNodeProvider_VGetProjectorStats(kNodeProvider provider, kSize index, kProjectorStats* stats);
kFsFx(kStatus) kNodeProvider_VGetAnalogOutStats(kNodeProvider provider, kSize index, kAnalogOutStats* stats);
kFsFx(kStatus) kNodeProvider_VGetDigitalOutStats(kNodeProvider provider, kSize index, kDigitalOutStats* stats);
kFsFx(kStatus) kNodeProvider_VGetSerialOutStats(kNodeProvider provider, kSize index, kSerialOutStats* stats);

kFsFx(kStatus) kNodeProvider_VResetIoTest(kNodeProvider provider, kSize index);
kFsFx(kStatus) kNodeProvider_VGetIoTestStats(kNodeProvider provider, kSize index, kIoTestStats* stats);
kFsFx(kStatus) kNodeProvider_VReadIoTestSerialData(kNodeProvider provider, kSize index, void* buffer, kSize capacity, kSize* bytesRead);

kFsFx(kStatus) kNodeProvider_VTestJigCommand(kNodeProvider provider, kTestJigCommand command, k64u data);
kFsFx(kStatus) kNodeProvider_VGetTestJigStats(kNodeProvider provider, kTestJigStats* stats);

kFsFx(kStatus) kNodeProvider_VLockOutLight(kNodeProvider provider, kSize index, kBool shouldLock);
kFsFx(kStatus) kNodeProvider_VSetLightDriverControl(kNodeProvider provider, kSize index, k64u key, kBool enabled);
kFsFx(kStatus) kNodeProvider_VGetLightDriverControl(kNodeProvider provider, kSize index, k64u key, kBool* enabled);
kFsFx(kStatus) kNodeProvider_VSetLightDriverPower(kNodeProvider provider, kSize index, k64u key, k32u power, kBool commit);
kFsFx(kStatus) kNodeProvider_VGetLightDriverPower(kNodeProvider provider, kSize index, k64u key, k32u* power);
kFsFx(kStatus) kNodeProvider_VSetLightDriverCurrentLimit(kNodeProvider provider, kSize index, k64u key, k32u currentLimit, kBool commit);
kFsFx(kStatus) kNodeProvider_VGetLightDriverCurrentLimit(kNodeProvider provider, kSize index, k64u key, k32u* currentLimit);
kFsFx(kStatus) kNodeProvider_VGetLightDriverRemainingSlotCount(kNodeProvider provider, kSize index, k64u key, kSize* remainingCount);
kFsFx(kStatus) kNodeProvider_VSetLightDriverInfo(kNodeProvider provider, kSize index, k64u key, kLightModel model, kVersion revision, k32u deviceId);
kFsFx(kStatus) kNodeProvider_VGetLightDriverInfo(kNodeProvider provider, kSize index, k64u key, kLightModel* model, kVersion* revision, k32u* deviceId);
kFsFx(kStatus) kNodeProvider_VSetLightDriverCalibration(kNodeProvider provider, kSize index, k64u key, kDataTree ldCal, kBool commit);
kFsFx(kStatus) kNodeProvider_VGetLightDriverCalibration(kNodeProvider provider, kSize index, k64u key, kDataTree* ldCal, kAlloc alloc);
kFsFx(kStatus) kNodeProvider_VReadLightDriverTemperature(kNodeProvider provider, kSize index, k64u key, k32s* temperature);

kFsFx(kStatus) kNodeProvider_VStartOrientationCalibration(kNodeProvider provider);
kFsFx(kStatus) kNodeProvider_VGetOrientationStats(kNodeProvider provider, kOrientationStats* stats);

#endif
