/** 
 * @file    kDiscoveryProvider.h
 * @brief   Declares the kDiscoveryProvider interface. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_DISCOVERY_PROVIDER_H
#define K_FIRESYNC_DISCOVERY_PROVIDER_H

#include <kFireSync/kNodeDef.h>
#include <kApi/Io/kStream.h>

/** Defines the signature for a discovery enumeration handler. */
typedef kStatus (kCall* kDiscoveryEnumFx)(kPointer context, kDiscoveryProvider provider, kArrayList info); 

/** Defines the signature for a discovery set-address handler. */
typedef kStatus (kCall* kDiscoveryAddressChangeFx)(kPointer context, kDiscoveryProvider provider, const kDiscoverySetAddressInfo* info); 

/**
 * @internal
 * @interface   kDiscoveryProvider
 * @ingroup     kFireSync-Client-Network
 * @brief       Represents a source for sensor discovery information.
 */
//typedef kObject kDiscoveryProvider;            --forward-declared in kFsDef.x.h

kFsFx(kStatus) kDiscoveryProvider_Construct(kDiscoveryProvider* provider, kType type, kSystem system, kAlloc allocator); 

kFsFx(kStatus) kDiscoveryProvider_AddAdapter(kDiscoveryProvider provider, const kChar* interfaceName);

kFsFx(kBool) kDiscoveryProvider_CanSetAddress(kDiscoveryProvider provider); 
kFsFx(kStatus) kDiscoveryProvider_SetAddress(kDiscoveryProvider provider, k32u id, kSize localAdapterId, kSize nodeInterfaceIndex, const kIpConfig* ipConfig); 

kFsFx(kStatus) kDiscoveryProvider_SetEnumHandler(kDiscoveryProvider provider, kDiscoveryEnumFx function, kPointer receiver); 
kFsFx(kStatus) kDiscoveryProvider_SetAddressChangeHandler(kDiscoveryProvider provider, kDiscoveryAddressChangeFx function, kPointer receiver); 

kFsFx(kStatus) kDiscoveryProvider_StartEnum(kDiscoveryProvider provider); 
kFsFx(kStatus) kDiscoveryProvider_WaitFirst(kDiscoveryProvider provider); 
kFsFx(kStatus) kDiscoveryProvider_StopEnum(kDiscoveryProvider provider); 

kFsFx(kStatus) kDiscoveryProvider_StartRescueRequests(kDiscoveryProvider provider); 
kFsFx(kStatus) kDiscoveryProvider_StopRescueRequests(kDiscoveryProvider provider); 

kFsFx(kStatus) kDiscoveryProvider_ConstructNodeProvider(kDiscoveryProvider provider, const kDiscoveryInfo* info, kNodeProvider* nodeProvider, kAlloc allocator); 

kFsFx(k64u) kDiscoveryProvider_ResetHoldTime(kDiscoveryProvider provider, kVersion protocolVersion); 

#include <kFireSync/Client/Network/kDiscoveryProvider.x.h>

#endif
