/** 
 * @file    kDiscovery6Client.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_DISCOVERY_6_CLIENT_X_H
#define K_FIRESYNC_DISCOVERY_6_CLIENT_X_H

#define kDISCOVERY_6_CLIENT_SOCKET_READ_BUFFER                      (4096)
#define kDISCOVERY_6_CLIENT_CLIENT_READ_BUFFER                      (1536)
#define kDISCOVERY_6_CLIENT_CLIENT_WRITE_BUFFER                     (1536)

#define kDISCOVERY_6_CLIENT_QUIT_QUERY_PERIOD                       (100000)
#define kDISCOVERY_6_CLIENT_QUIT_SEND_TIMEOUT                       (100000)
#define kDISCOVERY_6_CLIENT_DEFAULT_ENUM_PERIOD                     (1000000)

#define kDISCOVERY_6_CLIENT_DEFAULT_RESCUE_PERIOD                   (100000)

#define kDISCOVERY_6_CLIENT_LEGACY_RESET_HOLD_TIME                  (5000000)
#define kDISCOVERY_6_CLIENT_MODERN_RESET_PROTOCOL_VERSION           (kVersion_Create(6, 3, 1, 0))
#define kDISCOVERY_6_CLIENT_MODERN_RESET_HOLD_TIME                  (3000000)

typedef struct kDiscovery6ClientFilterItem
{
    kDiscoveryInfo* history[2];         //previous and current discovery information pointers for one node (either can be kNULL, if not detected)      
} kDiscovery6ClientFilterItem;

kDeclareValueEx(kFs, kDiscovery6ClientFilterItem, kValue)

typedef struct kDiscovery6ClientClass
{
    kObjectClass base; 
    k32u receivePort;                           //Receiver port. 
    kAlloc msgAlloc;                            //Message allocator, passed to constructed kNode6Client instances. 

    kThread enumThread;                         //Background thread to receive messages.
    k64u enumPeriod;                            //Enumeration period (us). 
    kDiscoveryEnumFx enumFx;                    //Enumeration callback. 
    kPointer enumRx;                            //Enumeration receiver. 
    kDiscoveryAddressChangeFx setAddressFx;     //Enumeration callback. 
    kPointer setAddressRx;                      //Enumeration receiver. 
    kUdpClient enumReceiver;                    //Receives broadcasts. 
    kSerializer enumReader;                     //Deserializes received messages. 
    kSemaphore enumFirstSem;                    //Set when first read is completed. 
    kList rawDiscovered;                        //Raw discovery messages received in this cycles -- kList<kDiscoveryInfo>. 
    kArrayList latestDiscovered;                //Nodes discovered since last update (analyzed, redundancies resolved) -- kArrayList<kDiscoveryInfo>. 
    kArrayList previousDiscovered;              //Nodes discovered in previous update (analyzed, redundancies resolved)-- kArrayList<kDiscoveryInfo>. 
    kArrayList filteredDiscovered;              //Node discovery history filter output -- kArrayList<kDiscoveryInfo>. 
    kMap filter;                                //Temporary structure used to filter previous/current items -- kMap<k32u, kDiscovery6ClientFilterItem>
    kMap interfacesReceived;                    //Temporary structure to note node interface indices from which messages have been received -- kMap<kSize, kSize>
    kBool allInterfacesReporting;               //Notes whether all node intefaces sent an update in the current enumeration cycle.
    kAtomic32s enumShouldQuit;                  //Indicates when enumeration thread should quit.
    kNetworkInfo netInfo;                       //Network information, used for end point preference comparisons. 
    kAtomic32s netInfoChanged;                  //Has network configuration information changed?

    kPeriodic rescueTimer;                      //Periodic background thread to send rescue requests. 
    k64u rescuePeriod;                          //Rescue broadcast period (us). 
    kArrayList rescueClients;                   //Rescue senders -- kArrayList<kUdpClient>. 
    kArrayList rescueWriters;                   //Rescue serializers -- kArrayList<kSerializer>

    kArrayList adapterList;                     //List of adapter ids to use for discovery -- kArrayList<kSize>

} kDiscovery6ClientClass; 

kDeclareClassEx(kFs, kDiscovery6Client, kObject)
        
kFsFx(kStatus) kDiscovery6Client_Init(kDiscovery6Client client, kType type, kAlloc alloc); 
kFsFx(kStatus) kDiscovery6Client_VRelease(kDiscovery6Client client); 

kFsFx(k64u) kDiscovery6Client_ResetHoldTime(kDiscovery6Client client, kVersion protocolVersion);  

kFsFx(kBool) kDiscovery6Client_CanSetAddress(kDiscovery6Client client); 
kFsFx(kStatus) kDiscovery6Client_SetAddress(kDiscovery6Client client, k32u id, kSize localAdapterId, kSize nodeInterfaceIndex, const kIpConfig* ipConfig);

kFsFx(kStatus) kDiscovery6Client_SetEnumHandler(kDiscovery6Client client, kDiscoveryEnumFx function, kPointer receiver); 
kFsFx(kStatus) kDiscovery6Client_SetAddressChangeHandler(kDiscovery6Client client, kDiscoveryAddressChangeFx function, kPointer receiver);

kFsFx(kStatus) kDiscovery6Client_StartEnum(kDiscovery6Client client); 
kFsFx(kStatus) kDiscovery6Client_WaitFirst(kDiscovery6Client client); 
kFsFx(kStatus) kDiscovery6Client_StopEnum(kDiscovery6Client client); 

kFsFx(kStatus) kDiscovery6Client_ConstructNodeProvider(kDiscovery6Client client, const kDiscoveryInfo* info, kNodeProvider* nodeProvider, kAlloc allocator); 

kFsFx(kStatus) kDiscovery6Client_EnumThreadEntry(kDiscovery6Client client); 
kFsFx(kStatus) kDiscovery6Client_ReceiveUpdate(kDiscovery6Client client, k64u timeout); 
kFsFx(kBool) kDiscovery6Client_IsCandidateAddressPreferred(kDiscovery6Client client, kIpAddress candidate, kIpAddress reference);
kFsFx(kStatus) kDiscovery6Client_ReadUpdate(kDiscovery6Client client, kDiscoveryInfo* info); 
kFsFx(kStatus) kDiscovery6Client_ReadAddressChange(kDiscovery6Client client, kDiscoverySetAddressInfo* info);

kFsFx(kStatus) kDiscovery6Client_Filter(kDiscovery6Client client); 
kFsFx(kStatus) kDiscovery6Client_AnalyzeDiscovered(kDiscovery6Client client);
kFsFx(kStatus) kDiscovery6Client_BuildFilter(kDiscovery6Client client);
kFsFx(kStatus) kDiscovery6Client_ParseFilterInputList(kDiscovery6Client client, kArrayList discovered, kSize index);
kFsFx(kStatus) kDiscovery6Client_EmitFilterResults(kDiscovery6Client client);
kFsFx(kStatus) kDiscovery6Client_SelectFilterItem(kDiscovery6Client client, const kDiscoveryInfo* previous, const kDiscoveryInfo* latest, kBool* useLatest);

kFsFx(kStatus) kDiscovery6Client_StartRescueRequests(kDiscovery6Client client); 
kFsFx(kStatus) kDiscovery6Client_StopRescueRequests(kDiscovery6Client client); 
kFsFx(kStatus) kDiscovery6Client_OnRescueTimer(kDiscovery6Client client, kPeriodic timer); 

kFsFx(kStatus) kDiscovery6Client_AddAdapter(kDiscovery6Client client, const kChar* name);
kFsFx(kBool) kDiscovery6Client_ShouldUseAdapter(kDiscovery6Client client, kSize adapterId);

kFsFx(kStatus) kDiscovery6Client_OnNetChange(kDiscovery6Client client, kPointer sender, kPointer args);
kFsFx(kStatus) kDiscovery6Client_RefreshNetInfo(kDiscovery6Client client);

#endif
