/** 
 * @file    kDiscovery5Client.h
 * @brief   Declares the kDiscovery5Client class. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_DISCOVERY_5_CLIENT_H
#define K_FIRESYNC_DISCOVERY_5_CLIENT_H

#include <kFireSync/Client/Network/kDiscoveryProvider.h>

/**
 * @internal
 * @class       kDiscovery5Client
 * @extends     kObject
 * @implements  kDiscoveryProvider
 * @ingroup     kFireSync-Client-Network
 * @brief       Provides an implementation of the kDiscoveryProvider interface based on FDP-5.
 *
 * This class provides the FS5 discovery protocol and the UBL 4.x legacy WaitForRescue message format.
 */
//typedef kObject kDiscovery5Client;            --forward-declared in kFsDef.x.h
 
/** 
 * Constructs a kDiscovery5Client object.
 *
 * @public              @memberof kDiscovery5Client
 * @return              Operation status. 
 */
kFsFx(kStatus) kDiscovery5Client_Construct(kDiscovery5Client* client, kSystem system, kAlloc allocator); 

kFsFx(kStatus) kDiscovery5Client_SetMessageAlloc(kDiscovery5Client client, kAlloc alloc); 

#include <kFireSync/Client/Network/kDiscovery5Client.x.h>

#endif
