/** 
 * @file    kControl6Client.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_CONTROL_6_CLIENT_X_H
#define K_FIRESYNC_CONTROL_6_CLIENT_X_H

#include <kApi/Io/kTcpClient.h>

#define kCONTROL_6_CLIENT_CLIENT_READ_BUFFER                (16384) 
#define kCONTROL_6_CLIENT_SOCKET_READ_BUFFER                (-1) 
#define kCONTROL_6_CLIENT_SOCKET_WRITE_BUFFER               (-1) 

#define kCONTROL_6_CLIENT_CONNECT_TIMEOUT                   (1000000)

typedef struct kControl6ClientClass
{
    kObjectClass base; 

    kCallback errorHandler;             //User callback for communication errors.
    kCallback cancelQuery;              //User callback for I/O cancellation.

    kStatus beginOpenStatus;            //Used to communicate state between BeginOpen/EndOpen.
    kTimer beginOpenTimer;              //Timer used with BeginOpen operation. 

    kTcpClient client;                  //Socket connection to remote device. 
    kSerializer serializer;             //Binary parser/formatter.

    kVersion remoteProtocolVersion;     //Protocol version supported by remote end point.
    kVersion remotePlatformVersion;     //Platform version supported by remote end point.

    k32u commandId;                     //Id of command currently being processed. 
    kBool commandAutoSize;              //Is the command size calculated automatically?
    kBool hasError;                     //Has a control commmunication error occurred?

} kControl6ClientClass; 

kDeclareClassEx(kFs, kControl6Client, kObject)
        
kFsFx(kStatus) kControl6Client_Init(kControl6Client client, kType type, kAlloc alloc); 
kFsFx(kStatus) kControl6Client_VRelease(kControl6Client client); 

kFsFx(kStatus) kControl6Client_OnError(kControl6Client client, kStatus status); 

kFsFx(kStatus) kControl6Client_BeginWriteCommand(kControl6Client client, k32u id, kSize contentSize); 
kFsFx(kStatus) kControl6Client_EndWriteCommand(kControl6Client client); 
kFsFx(kStatus) kControl6Client_BeginReadReply(kControl6Client client, kStatus* status); 
kFsFx(kStatus) kControl6Client_EndReadReply(kControl6Client client); 

kFsFx(kStatus) kControl6Client_BeginReadReplyWithProgress(kControl6Client client, kCallbackFx progress, kPointer context, kStatus* opStatus);

kFsFx(void) kControl6Client_UpdateProgress(kCallbackFx progress, kPointer context, k32u progressValue);

kFsFx(kStatus) kControl6Client_InformVersion(kControl6Client client);

kFsFx(kStatus) kControl6Client_ListDirectoryEntriesExModern(kControl6Client client, const kChar* path, kArrayList entries);
kFsFx(kStatus) kControl6Client_ListDirectoryEntriesExLegacy(kControl6Client client, const kChar* path, kArrayList entries);

#endif
