/** 
 * @file    kLc65xInfo.h
 * @brief   Declares the kLc65xInfo class and related types. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_LC65X_INFO_H
#define K_FIRESYNC_LC65X_INFO_H

#include <kFireSync/Client/Camera/kCameraInfo.h>

/**
 * @internal
 * @class   kLc65xInfo
 * @extends kCameraInfo
 * @ingroup kFireSync-Client-Camera
 * @brief   Represents information about the LC65x camera model. 
 */
//typedef kCameraInfo kLc65xInfo;             --forward-declared in kFsDef.x.h

/** 
 * Constructs a kLc65xInfo object.
 *
 * @public                  @memberof kLc65xInfo
 * @param   info            Destination for the constructed object handle. 
 * @param   model           Camera model. 
 * @param   capabilities    Camera algorithm capabilities. 
 * @param   allocator       Memory allocator (or kNULL for default). 
 * @return                  Operation status. 
 */
kFsFx(kStatus) kLc65xInfo_Construct(kLc65xInfo* info, kCameraModel model, kCameraCapability capabilities, kBool isTrailingRequired, kSize frameSizeGranularity, kVersion plVersion, kAlloc allocator);

#include <kFireSync/Client/Camera/kLc65xInfo.x.h>

#endif
