/** 
 * @file    kLc200xInfo.h
 * @brief   Declares the kLc200xInfo class and related types. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_LC200X_INFO_H
#define K_FIRESYNC_LC200X_INFO_H

#include <kFireSync/Client/Camera/kCameraInfo.h>

/**
 * @internal
 * @class   kLc200xInfo
 * @extends kCameraInfo
 * @ingroup kFireSync-Client-Camera
 * @brief   Represents information about the LC200x camera model. 
 */
//typedef kCameraInfo kLc200xInfo;             --forward-declared in kFsDef.x.h

/** 
 * Constructs a kLc200xInfo object.
 *
 * @public                  @memberof kLc200xInfo
 * @param   info            Destination for the constructed object handle. 
 * @param   model           Camera model. 
 * @param   capabilities    Camera algorithm capabilities. 
 * @param   allocator       Memory allocator (or kNULL for default). 
 * @return                  Operation status. 
 */
kFsFx(kStatus) kLc200xInfo_Construct(kLc200xInfo* info, kCameraModel model, kCameraCapability capabilities, kBool isTrailingRequired, kSize frameSizeGranularity, kVersion plVersion, kAlloc allocator);

#include <kFireSync/Client/Camera/kLc200xInfo.x.h>

#endif
