/** 
 * @file    kLc150Info.h
 * @brief   Declares the kLc150Info class and related types. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_LC150_INFO_H
#define K_FIRESYNC_LC150_INFO_H

#include <kFireSync/Client/Camera/kCameraInfo.h>

/**
 * @internal
 * @class   kLc150Info
 * @extends kCameraInfo
 * @ingroup kFireSync-Client-Camera
 * @brief   Represents information about the LC150 camera model. 
 */
//typedef kCameraInfo kLc150Info;             --forward-declared in kFsDef.x.h

/** 
 * Constructs a kLc150Info object.
 *
 * @public                  @memberof kLc150Info
 * @param   info            Destination for the constructed object handle. 
 * @param   capabilities    Camera algorithm capabilities. 
 * @param   allocator       Memory allocator (or kNULL for default). 
 * @return                  Operation status. 
 */
kFsFx(kStatus) kLc150Info_Construct(kLc150Info* info, kCameraCapability capabilities, kBool isTrailingRequired, kSize frameSizeGranularity, kVersion plVersion, kAlloc allocator);

#include <kFireSync/Client/Camera/kLc150Info.x.h>

#endif
