/** 
 * @file    kCameraOverride.h
 * @brief   Declares the kCameraOverride type. 
 *
 * @internal
 * Copyright (C) 2015-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_CAMERA_OVERRIDE_H
#define K_FIRESYNC_CAMERA_OVERRIDE_H

#include <kFireSync/Client/Camera/Extensions/kCameraExt.h>

/**
 * @class   kCameraOverride
 * @extends kCameraExt
 * @ingroup kFireSync-Client-Camera-Extensions
 * @brief   Represents parameters for a camera override extension. 
 * 
 * This extension enables certain camera parameters to be controlled dynamically in software. 
 * When this extension is enabled, dynamic control is supported via two methods: pipe messages
 * and the FireSync control API. The aim of this feature is to support software-based dynamic 
 * exposure and window tracking algorithms. 
 *  
 * To use this feature from within the pipe, implement a block that will provide dynamic control 
 * and then route messages from this block to the desired camera "Override" port. Dynamic control 
 * messages are structured as kMsg objects containing kArrayList objects with element type 
 * kCameraOverrideItem. 
 * 
 * Refer to the kCamera_Override function for information on how to use this feature via the 
 * FireSync control API.  
 */
//typedef kCameraExt kCameraOverride;            --forward-declared in kFsDef.x.h

#include <kFireSync/Client/Camera/Extensions/kCameraOverride.x.h>

#endif
