/** 
 * @file    kCameraExt.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_CAMERA_EXT_X_H
#define K_FIRESYNC_CAMERA_EXT_X_H

#include <kApi/Data/kXml.h>

#define kCAMERA_EXT_DEFAULT_STATE_CAPACITY          (k8U_MAX)        //Maximum number of states (state ids have 8-bit representation in camera driver). 

typedef struct kCameraExtClass
{
    kObjectClass base; 
    kCamera camera;                 //Optional reference to camera; used in client-side validation/verification. 
    kCameraExtension typeId;        //Numeric type identifier. 
    kBool isExclusive;              //Is the extension exclusive?
    kBool isSequence;               //Does this extension implement state sequencing logic?
    kBool requiresInterrupts;       //Does this extension require SoE/EoE interrupts to be enabled?
    kBool isEnabled;                //Is the extension currently enabled?
    kSize minStateCount;            //Can be set by child types to communicate minimum required camera states. 
    kSize maxStateCount;            //Can be set by child types to communicate maximum supported camera states. 
} kCameraExtClass; 

typedef struct kCameraExtVTable
{
    kObjectVTable base; 
    kStatus (kCall* VRead)(kCameraExt extension, kXml xml, kXml item);    
    kStatus (kCall* VWrite)(kCameraExt extension, kXml xml, kXml item);    
    kStatus (kCall* VVerify)(kCameraExt extension); 
    kStatus (kCall* VClear)(kCameraExt extension); 
    kStatus (kCall* VNextStates)(kCameraExt extension, kSize stateIndex, kSize stateCount, kArrayList nextStates); 
    k64u (kCall* VMinimumPeriod)(kCameraExt extension); 
    kSize (kCall* VInputPortCount)(kCameraExt extension); 
    kStatus (kCall* VInputPortInfo)(kCameraExt extension, kSize index, kPortInfo* info);  
    kSize (kCall* VOutputPortCount)(kCameraExt extension); 
    kStatus (kCall* VOutputPortInfo)(kCameraExt extension, kSize index, kPortInfo* info);  
    kBool (kCall* VIsInterruptRequired)(kCameraExt extension); 
} kCameraExtVTable; 

kDeclareVirtualClassEx(kFs, kCameraExt, kObject)

kFsFx(kStatus) kCameraExt_Construct(kCameraExt* extension, kType type, kAlloc allocator); 

kFsFx(kStatus) kCameraExt_Load(kCameraExt* extension, kXml xml, kXmlItem item, kAlloc allocator); 
kFsFx(kStatus) kCameraExt_Save(kCameraExt extension, kXml xml, kXmlItem item); 

kFsFx(kStatus) kCameraExt_Init(kCameraExt extension, kType type, kAlloc alloc); 
kFsFx(kStatus) kCameraExt_VRelease(kCameraExt extension); 

kFsFx(kCameraExtension) kCameraExt_TypeId(kCameraExt extension); 

kFsFx(kStatus) kCameraExt_Read(kCameraExt extension, kXml xml, kXmlItem item); 
kFsFx(kStatus) kCameraExt_VRead(kCameraExt extension, kXml xml, kXmlItem item); 

kFsFx(kStatus) kCameraExt_Write(kCameraExt extension, kXml xml, kXmlItem item); 
kFsFx(kStatus) kCameraExt_VWrite(kCameraExt extension, kXml xml, kXmlItem item); 

kFsFx(kStatus) kCameraExt_SetCamera(kCameraExt extension, kCamera camera); 

kFsFx(kStatus) kCameraExt_Clear(kCameraExt extension); 
kFsFx(kStatus) kCameraExt_VClear(kCameraExt extension); 

kFsFx(kStatus) kCameraExt_Verify(kCameraExt extension); 
kFsFx(kStatus) kCameraExt_VVerify(kCameraExt extension); 

kFsFx(kBool) kCameraExt_IsExclusive(kCameraExt extension);
kFsFx(kBool) kCameraExt_IsSequence(kCameraExt extension);
kFsFx(kBool) kCameraExt_RequiresInterrupts(kCameraExt extension); 

kFsFx(kStatus) kCameraExt_NextStates(kCameraExt extension, kSize stateIndex, kSize stateCount, kArrayList nextStates); 
kFsFx(kStatus) kCameraExt_VNextStates(kCameraExt extension, kSize stateIndex, kSize stateCount, kArrayList nextStates); 

kFsFx(k64u) kCameraExt_MinimumPeriod(kCameraExt extension); 
kFsFx(k64u) kCameraExt_VMinimumPeriod(kCameraExt extension); 

kFsFx(kSize) kCameraExt_InputPortCount(kCameraExt extension); 
kFsFx(kSize) kCameraExt_VInputPortCount(kCameraExt extension); 

kFsFx(kStatus) kCameraExt_InputPortInfo(kCameraExt extension, kSize index, kPortInfo* info);  
kFsFx(kStatus) kCameraExt_VInputPortInfo(kCameraExt extension, kSize index, kPortInfo* info);  

kFsFx(kSize) kCameraExt_OutputPortCount(kCameraExt extension); 
kFsFx(kSize) kCameraExt_VOutputPortCount(kCameraExt extension); 

kFsFx(kStatus) kCameraExt_OutputPortInfo(kCameraExt extension, kSize index, kPortInfo* info);  
kFsFx(kStatus) kCameraExt_VOutputPortInfo(kCameraExt extension, kSize index, kPortInfo* info);  

kFsFx(kSize) kCameraExt_MinStateCount(kCameraExt extension); 
kFsFx(kSize) kCameraExt_MaxStateCount(kCameraExt extension); 

kFsFx(kBool) kCameraExt_IsInterruptRequired(kCameraExt extension); 
kFsFx(kBool) kCameraExt_VIsInterruptRequired(kCameraExt extension); 

#endif
