/** 
 * @file    kCameraDynFpn.x.h
 *
 * @internal
 * Copyright (C) 2015-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_CAMERA_DYN_FPN_X_H
#define K_FIRESYNC_CAMERA_DYN_FPN_X_H

typedef struct kCameraDynFpnClass
{
    kCameraExtClass base; 
    kArrayList inputPorts;
} kCameraDynFpnClass; 

kDeclareClassEx(kFs, kCameraDynFpn, kCameraExt)

/** 
 * Constructs a kCameraDynFpn object.
 *
 * @public              @memberof kCameraDynFpn
 * @param   extension   Destination for the constructed object handle. 
 * @param   allocator   Memory allocator (or kNULL for default). 
 * @return              Operation status. 
 */
kFsFx(kStatus) xkCameraDynFpn_Construct(kCameraDynFpn* extension, kAlloc allocator); 

kFsFx(kStatus) kCameraDynFpn_Init(kCameraDynFpn extension, kType type, kAlloc alloc); 
kFsFx(kStatus) kCameraDynFpn_VRelease(kCameraDynFpn extension); 

kFsFx(kStatus) kCameraDynFpn_ComposeInputPorts(kCameraDynFpn extension); 

kFsFx(kStatus) kCameraDynFpn_VClone(kCameraDynFpn extension, kCameraDynFpn other, kAlloc valueAlloc, kObject context); 

kFsFx(kStatus) kCameraDynFpn_VRead(kCameraDynFpn extension, kXml xml, kXmlItem item); 
kFsFx(kStatus) kCameraDynFpn_VWrite(kCameraDynFpn extension, kXml xml, kXmlItem item); 

kFsFx(kStatus) kCameraDynFpn_VerificationLabel(kCameraDynFpn extension, kChar* label, kSize capacity); 
kFsFx(kStatus) kCameraDynFpn_CheckWindowViolations(kCameraDynFpn extension, kNode node, kChar* label); 
kFsFx(kStatus) kCameraDynFpn_VVerify(kCameraDynFpn extension); 

kFsFx(kStatus) kCameraDynFpn_VNextStates(kCameraDynFpn extension, kSize stateIndex, kSize stateCount, kArrayList nextStates);

kFsFx(kSize) kCameraDynFpn_VInputPortCount(kCameraDynFpn extension); 
kFsFx(kStatus) kCameraDynFpn_VInputPortInfo(kCameraDynFpn extension, kSize index, kPortInfo* info);  

kFsFx(kBool) kCameraDynFpn_VIsInterruptRequired(kCameraDynFpn extension); 

#endif
