/** 
 * @file    kInvertBlock.x.h
 *
 * @internal
 * Copyright (C) 2014-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_INVERT_BLOCK_X_H
#define K_FIRESYNC_INVERT_BLOCK_X_H

#include <kFireSync/Pipe/kPxBlock.h>

typedef struct kInvertBlockClass
{
    kPxBlockClass base; 
    kInvertBlockInfo info;          //Block settings.
    kPxPort outputPort;             //Output port.
    kInvertAlg algorithm;           //Algorithm engine.
} kInvertBlockClass; 

kDeclareClassEx(kFs, kInvertBlock, kPxBlock)

kFsFx(const kChar*) kInvertBlock_VDescription(); 

kFsFx(kStatus) kInvertBlock_VOnSetup(kInvertBlock block);
kFsFx(kStatus) kInvertBlock_VOnStart(kInvertBlock block);
kFsFx(kStatus) kInvertBlock_VOnStop(kInvertBlock block);
kFsFx(kStatus) kInvertBlock_VOnReceive(kInvertBlock block, kPxPort port, kMsgSet msg);

#endif
