/** 
 * @file    kBinCSum4Block.x.h
 *
 * @internal
 * Copyright (C) 2016-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_BIN_CSUM4_BLOCK_X_H
#define K_FIRESYNC_BIN_CSUM4_BLOCK_X_H

#include <kFireSync/Pipe/kPxBlock.h>

#define kBIN_CSUM4_BLOCK_NOISE_WIDTH            (32)        //Number of columns used for background noise. 

typedef struct kBinCSum4BlockClass
{
    kPxBlockClass base; 
    kBinCSum4BlockInfo info;        //Settings. 
    kSize backgroundWidth;          //Background columns sampled for noise, before subsampling.
    kBinCSum4Alg algorithm;         //BinCSum4 algorithm context. 
    kArray2 attachedBin;            //Binds bin output data to kArray2 for algorithm. 
    kArray1 attachedCSum;           //Binds csum output data to kArray1 for algorithm. 
    kPxPort outPort;                //Cached output port.   
} kBinCSum4BlockClass; 

kDeclareClassEx(kFs, kBinCSum4Block, kPxBlock)

kFsFx(const kChar*) kBinCSum4Block_VDescription(); 

kFsFx(kStatus) kBinCSum4Block_VOnSetup(kBinCSum4Block block);
kFsFx(kStatus) kBinCSum4Block_VOnStart(kBinCSum4Block block);
kFsFx(kStatus) kBinCSum4Block_VOnStop(kBinCSum4Block block);
kFsFx(kStatus) kBinCSum4Block_VOnReceive(kBinCSum4Block block, kPxPort port, kMsgSet msg);

#endif
