/** 
 * @file    kLvdsEyeAction.x.h
 * 
 * @internal
 * Copyright (C) 2018-2022 by LMI Technologies Inc. All rights reserved.
 */
#ifndef K_FIRESYNC_LVDS_EYE_ACTION_X_H
#define K_FIRESYNC_LVDS_EYE_ACTION_X_H

#include <kFireSync/Action/kAxAction.h>

#define kLVDS_EYE_ACTION_CHANNEL_COUNT                      (33)     //32 data + 1 sync
#define kLVDS_EYE_ACTION_DATA_CHANNEL_COUNT                 (32)
#define kLVDS_EYE_ACTION_SYNC_CHANNEL_INDEX                 (32)

#define kLVDS_EYE_ACTION_MAX_DELAY                          (63)

#define kLVDS_EYE_ACTION_PL_CAMERA_0_MODULE_INDEX           (0x20)

#define kHW_PL_CAMERA_DESERIALIZER_DELAY_INDEX              (0x44)

#define kHW_PL_CAMERA_DESERIALIZER_DELAY_CH_NUM_MASK        (0x000000FF)
#define kHW_PL_CAMERA_DESERIALIZER_DELAY_CH_NUM_SHIFT       (0)

#define kHW_PL_CAMERA_DESERIALIZER_DELAY_DELAY_TAPS_MASK    (0x00001F00)
#define kHW_PL_CAMERA_DESERIALIZER_DELAY_DELAY_TAPS_SHIFT   (8)

#define kHW_PL_CAMERA_DESERIALIZER_DELAY_WRAPAROUND_MASK    (0x00006000)
#define kHW_PL_CAMERA_DESERIALIZER_DELAY_WRAPAROUND_SHIFT   (13)

#define kHW_PL_CAMERA_DESERIALIZER_DELAY_MODE_MASK          (0x00008000)
#define kHW_PL_CAMERA_DESERIALIZER_DELAY_MODE_SHIFT         (15)

#define kHW_PL_CAMERA_DESERIALIZER_DELAY_MODE_DPA           (0)
#define kHW_PL_CAMERA_DESERIALIZER_DELAY_MODE_SW            (1)

#define kHW_PL_CAMERA_DESERIALIZER_DELAY_WRITE_MASK         (0x00010000)
#define kHW_PL_CAMERA_DESERIALIZER_DELAY_WRITE_SHIFT        (16)

#define kHW_PL_CAMERA_DESERIALIZER_DELAY_CURRENT_MASK       (0x1F000000)
#define kHW_PL_CAMERA_DESERIALIZER_DELAY_CURRENT_SHIFT      (24)

typedef struct kLvdsEyeDiagram
{
    k32s dpa;
    k32s low;
    k32s high;
} kLvdsEyeDiagram;

typedef struct kLvdsEyeActionClass
{
    kAxActionClass base; 
    kNode node;
    kCamera camera;
    kTimer timer;
    kArrayList channels;

    k32u tapsPerBit;
    k64u duration;
    kBool channelEnabled[kLVDS_EYE_ACTION_CHANNEL_COUNT];
    kBool finished[kLVDS_EYE_ACTION_CHANNEL_COUNT];
    k64u channelAlignmentErrorCount[kLVDS_EYE_ACTION_CHANNEL_COUNT];
    k64u lastImagerDesyncCount;
    kLvdsEyeDiagram eyeDiagram[kLVDS_EYE_ACTION_CHANNEL_COUNT];
} kLvdsEyeActionClass; 

kDeclareClassEx(kFs, kLvdsEyeAction, kAxAction)

kFsFx(const kChar*) kLvdsEyeAction_VDescription();
kFsFx(kStatus) kLvdsEyeAction_VValidate(kXml settings, kAlloc alloc);
kFsFx(kStatus) kLvdsEyeAction_VInvoke(kLvdsEyeAction action, kObject input, kObject* output, kAlloc alloc);

kFsFx(kBool) kLvdsEyeAction_ParseInput(kLvdsEyeAction action, kXml input);
kFsFx(kBool) kLvdsEyeAction_FormatOutput(kLvdsEyeAction action, kXml* input, kAlloc alloc);

kFsFx(kStatus) kLvdsEyeAction_SetDpa(kLvdsEyeAction action, kBool saveDpaDelay);
kFsFx(kStatus) kLvdsEyeAction_SetChannelDelay(kLvdsEyeAction action, kSize index, k32s adjustDelay);
kFsFx(kStatus) kLvdsEyeAction_RestoreDpa(kLvdsEyeAction action);
kFsFx(kStatus) kLvdsEyeAction_ReadAlignmentStatus(kLvdsEyeAction action);
kFsFx(kStatus) kLvdsEyeAction_ResetAlignmentErrorCount(kLvdsEyeAction action);
kFsFx(kBool) kLvdsEyeAction_AllChannelHasError(kLvdsEyeAction action);
kFsFx(kBool) kLvdsEyeAction_IsAllChannelFinished(kLvdsEyeAction action);
kFsFx(kStatus) kLvdsEyeAction_QualifyDelay(kLvdsEyeAction action, k32s adjustDelay);
kFsFx(kStatus) kLvdsEyeAction_FindHighMargin(kLvdsEyeAction action);
kFsFx(kStatus) kLvdsEyeAction_FindLowMargin(kLvdsEyeAction action);
kFsFx(kStatus) kLvdsEyeAction_FindRange(kLvdsEyeAction action);
kFsFx(kStatus) kLvdsEyeAction_BuildSyncChannel(kLvdsEyeAction action);
kFsFx(kStatus) kLvdsEyeAction_BuildDataChannel(kLvdsEyeAction action);
kFsFx(kStatus) kLvdsEyeAction_BuildErrorChannel(kLvdsEyeAction action);
kFsFx(kStatus) kLvdsEyeAction_Measure(kLvdsEyeAction action, kObject* output, kAlloc alloc);

#endif
