#ifndef GV_SURFACE_MSG_X_H
#define GV_SURFACE_MSG_X_H

typedef struct GvSurfaceMsgReadHeader
{
    GvDataMsgReadHeader base;
    kBool isResampled;
    kBool isAdjacent;
} GvSurfaceMsgReadHeader;

typedef struct GvSurfaceMsgClass
{
    GvDataMsgClass base;

    // GOC-13342: For a surface, this table contains the index along the width of the surface which
    // indicates the start of each profile that makes up each sub-surface 
    // (except for the first surface) that make up this surface.
    // So this table is only available for buddied G2 sensors. For standalone G2 sensors,
    // this table is not needed so the table will not be allocated.
    // The index values are all 0-based.
    //
    // Array[N-1][surface length L] k32u values for a N-sensor configuration. Is set to kNULL if this information is not available.
    kArray2 surfaceStartTable;

    kBool isResampled;
    kBool isAdjacent;

    GvSurfaceFrameOfReferenceType frameOfReference;
} GvSurfaceMsgClass; 

kDeclareClassEx(Gv, GvSurfaceMsg, GvDataMsg)

typedef k32s GvSurfaceMsg_PoseId;

GvFx(kStatus) GvSurfaceMsg_Init(GvSurfaceMsg msg, kType type, kSize width, kSize height, kBool initRangeLayer, kType rangeType, kAlloc allocator);
GvFx(kStatus) GvSurfaceMsg_VInitClone(GvSurfaceMsg msg, GvSurfaceMsg src, kAlloc alloc);
GvFx(kStatus) GvSurfaceMsg_VRelease(GvSurfaceMsg msg);
GvFx(kPoint3d64f) GvSurfaceMsg_VOffsetWithRef(GvSurfaceMsg msg);

GvFx(kStatus) GvSurfaceMsg_Assign(GvSurfaceMsg msg, GvSurfaceMsg src);

GvFx(kStatus) GvSurfaceMsg_WriteMsgHeader(GvSurfaceMsg msg, kSerializer serializer, kTypeVersion* stampVersion);
GvFx(kStatus) GvSurfaceMsg_WriteDat6V0(GvSurfaceMsg msg, kSerializer serializer);
GvFx(kStatus) GvSurfaceMsg_ReadDat6V0(GvSurfaceMsg msg, kSerializer serializer, kAlloc allocator);
GvFx(kStatus) GvSurfaceMsg_WriteDat6V1(GvSurfaceMsg msg, kSerializer serializer);
GvFx(kStatus) GvSurfaceMsg_ReadDat6V1(GvSurfaceMsg msg, kSerializer serializer, kAlloc allocator);

GvFx(kStatus) GvSurfaceMsg_FromDataMsg(GvSurfaceMsg* msg, GvDataMsg src, kAlloc alloc);

GvFx(const kStamp*) GvSurfaceMsg_Stamp(GvSurfaceMsg msg);
GvFx(kStatus) GvSurfaceMsg_SetStamp(GvSurfaceMsg msg, const kStamp* stamp);

GvFx(k64u) GvSurfaceMsg_Time(GvSurfaceMsg msg);
GvFx(kStatus) GvSurfaceMsg_SetTime(GvSurfaceMsg msg, k64u time);

GvFx(k64s) GvSurfaceMsg_Encoder(GvSurfaceMsg msg);
GvFx(kStatus) GvSurfaceMsg_SetEncoder(GvSurfaceMsg msg, k64s encoder);

GvFx(const kPoint3d64f*) GvSurfaceMsg_Offset(GvSurfaceMsg msg);
GvFx(kStatus) GvSurfaceMsg_SetOffset(GvSurfaceMsg msg, const kPoint3d64f* offset);

GvFx(const kPoint3d64f*) GvSurfaceMsg_Scale(GvSurfaceMsg msg);
GvFx(kStatus) GvSurfaceMsg_SetScale(GvSurfaceMsg msg, const kPoint3d64f* scale);

GvFx(kStatus) GvSurfaceMsg_SetRanges(GvSurfaceMsg msg, kArray2 ranges);
GvFx(kArray2) GvSurfaceMsg_Ranges(GvSurfaceMsg msg);
GvFx(const void*) GvSurfaceMsg_Range(GvSurfaceMsg msg, kSize index0, kSize index1);

GvFx(kStatus) GvSurfaceMsg_SetIntensities(GvSurfaceMsg msg, kArray2 intensities);
GvFx(kArray2) GvSurfaceMsg_Intensities(GvSurfaceMsg msg);
GvFx(const k8u*) GvSurfaceMsg_IntensityAt(GvSurfaceMsg msg, kSize index0, kSize index1);

GvFx(kStatus) GvSurfaceMsg_OffsetForRef(GvSurfaceMsg msg, GvSurfaceFrameOfReferenceType ref, kPoint3d64f* offset);

GvFx(kBool) GvSurfaceMsg_Compare(GvSurfaceMsg msg0, GvSurfaceMsg msg1);
GvFx(kStatus) GvSurfaceMsg_AddPose(GvSurfaceMsg msg, const kPose2d64f* pose, GvSurfaceMsg_PoseId id);
GvFx(kStatus) GvSurfaceMsg_SelectPose(GvSurfaceMsg msg, GvSurfaceMsg_PoseId id, kPose2d64f* pose);
GvFx(kStatus) GvSurfaceMsg_SelectPoseInverse(GvSurfaceMsg msg, GvSurfaceMsg_PoseId fromId, kPose2d64f* pose);
GvFx(kStatus) GvSurfaceMsg_SelectPoseRelative(GvSurfaceMsg msg, GvSurfaceMsg_PoseId toId, GvSurfaceMsg_PoseId fromId, kPose2d64f* pose);
GvFx(kStatus) GvSurfaceMsg_AssignPose(GvSurfaceMsg dstMsg, kMsgSet srcMsg, kAlloc allocator);

GvFx(kSize) GvSurfaceMsg_PoseCount(GvSurfaceMsg msg);
GvFx(kStatus) GvSurfaceMsg_Pose(GvSurfaceMsg msg, kSize index, kPose2d64f* pose, GvSurfaceMsg_PoseId* id);
GvFx(kStatus) GvSurfaceMsg_SetPose(GvSurfaceMsg msg, kSize index, kPose2d64f* pose, GvSurfaceMsg_PoseId id);

GvFx(kStatus) GvSurfaceMsg_SetFrameOfReference(GvSurfaceMsg msg, GvSurfaceFrameOfReferenceType type);
GvFx(GvSurfaceFrameOfReferenceType) GvSurfaceMsg_FrameOfReference(GvSurfaceMsg msg);

//This is set by the constructor and probably shouldn't ever be changed...
GvFx(kStatus) GvSurfaceMsg_SetIsResampled(GvSurfaceMsg msg, kBool isResampled);

GvFx(kStatus) GvSurfaceMsg_VDataAt(GvSurfaceMsg msg, kSize frame, kArrayList* list);

#endif
