#ifndef GV_RANGE_MSG_X_H
#define GV_RANGE_MSG_X_H

#include <GoVision/GvDef.h>
#include <GoVision/GvUtils.h>
#include <kFireSync/Data/kMsgSet.h>
#include <kFireSync/Data/kProfileMsg.h>
#include <kApi/Data/kArray1.h>
#include <kApi/Data/kArrayList.h>

typedef struct GvRangeMsgClass
{
    GvDataMsgClass base;
} GvRangeMsgClass; 

kDeclareClassEx(Gv, GvRangeMsg, GvDataMsg)

GvFx(kStatus) GvRangeMsg_Init(GvRangeMsg msg, kType type, kType pointType, kSize count, kSize pointCount, kAlloc allocator);
GvFx(kStatus) GvRangeMsg_VInitClone(GvRangeMsg msg, GvRangeMsg src, kAlloc alloc);
GvFx(kStatus) GvRangeMsg_VRelease(GvRangeMsg msg);

GvFx(kStatus) GvRangeMsg_WriteDat6V0(GvRangeMsg msg, kSerializer serializer);
GvFx(kStatus) GvRangeMsg_ReadDat6V0(GvRangeMsg msg, kSerializer serializer, kAlloc allocator);

GvFx(kStatus) GvRangeMsg_FromDataMsg(GvRangeMsg* msg, GvDataMsg src, kAlloc alloc);
GvFx(kStatus) GvRangeMsg_ToDataMsg(GvDataMsg* msg, GvRangeMsg src, kAlloc alloc);

GvFx(kStatus) GvRangeMsg_FromKProfileMsg(GvRangeMsg* msg, kProfileMsg src, kBool includeIntensity, kAlloc alloc);

GvFx(const kPoint3d64f*) GvRangeMsg_OffsetAt(GvRangeMsg msg, kSize frame);
GvFx(kStatus) GvRangeMsg_SetOffsetAt(GvRangeMsg msg, kSize frame, const kPoint3d64f* offset);

GvFx(const kPoint3d64f*) GvRangeMsg_ScaleAt(GvRangeMsg msg, kSize frame);
GvFx(kStatus) GvRangeMsg_SetScaleAt(GvRangeMsg msg, kSize frame, const kPoint3d64f* scale);

GvFx(k64u) GvRangeMsg_TimeAt(GvRangeMsg msg, kSize frame);
GvFx(kStatus) GvRangeMsg_SetTimeAt(GvRangeMsg msg, kSize frame, k64u time);

GvFx(k64s) GvRangeMsg_EncoderAt(GvRangeMsg msg, kSize frame);
GvFx(kStatus) GvRangeMsg_SetEncoderAt(GvRangeMsg msg, kSize frame, k64s encoder);

GvFx(kSize) GvRangeMsg_PointCountAt(GvRangeMsg msg, kSize frame);

GvFx(void*) GvRangeMsg_RangeAt(GvRangeMsg msg, kSize frame, kSize point);

GvFx(k8u*) GvRangeMsg_IntensityAt(GvRangeMsg msg, kSize frame, kSize point);

GvFx(const k8u*) GvRangeMsg_MapValueAt(GvRangeMsg msg, kSize frame, kSize point);
GvFx(kBool) GvRangeMsg_HasMap(GvRangeMsg msg);

GvFx(kBool) GvRangeMsg_HasSlices(GvRangeMsg msg);
GvFx(const k16u*) GvRangeMsg_SliceValueAt(GvRangeMsg msg, kSize frame, kSize point);

/** 
 * Creates a new message by taking the selected frame indices from a batched message.
 *
 * @public              @memberof GvRangeMsg
 * @param   msg         Message object. 
 * @param   output      Pointer to receive the new object.
 * @param   start       First selected index.
 * @param   count       Number of selected indices.
 * @param   alloc       Allocator used to construct the new object.
 * @return              Operation status.
 */
GvFx(kStatus) GvRangeMsg_FrameSlice(GvRangeMsg msg, GvRangeMsg* output, kSize start, kSize count, kAlloc alloc);

#endif
