#ifndef GV_MEASURE_MSG_X_H
#define GV_MEASURE_MSG_X_H

#include <GoVision/Data/GvMeasureMsg.h>

#define kPROFILE_MSG_ALIGNMENT_BYTES        (8)

typedef struct GvMeasureMsgFrame
{
    kStamp stamp;
    k64f value;
    k64f unfilteredValue;
    k32s status;
    kByte padding[4];
    kObject objectExtension;
    kPoint3d64f labelPosition;
    kObject renderingObject;
} GvMeasureMsgFrame;

typedef struct GvMeasureMsgClass
{
    kMsgSetClass base; 
    kSize count;
    kSize dataSize;
    
    kSize frameSize;
    kSize bufferSize;
    void* buffer;
} GvMeasureMsgClass; 

kDeclareClassEx(Gv, GvMeasureMsg, kMsgSet)
        
GvFx(kStatus) GvMeasureMsg_Construct(GvMeasureMsg* msg, kSize count, kSize dataSize, kAlloc allocator);
GvFx(kStatus) GvMeasureMsg_Init(GvMeasureMsg msg, kType type, kSize count, kSize dataSize, kAlloc alloc);
GvFx(kStatus) GvMeasureMsg_VRelease(GvMeasureMsg msg);
GvFx(kStatus) GvMeasureMsg_VInitClone(GvMeasureMsg msg, GvMeasureMsg other, kAlloc alloc); 
GvFx(kSize) GvMeasureMsg_VSize(GvMeasureMsg msg);

GvFx(kSize) GvMeasureMsg_VCount(GvMeasureMsg msg);
GvFx(const kStamp*) GvMeasureMsg_VStampAt(GvMeasureMsg msg, kSize index);
GvFx(kStatus) GvMeasureMsg_VDataAt(GvMeasureMsg msg, kSize index, kArrayList* list);

GvFx(kStatus) GvMeasureMsg_WriteDat6V0(GvMeasureMsg msg, kSerializer serializer);
GvFx(kStatus) GvMeasureMsg_ReadDat6V0(GvMeasureMsg msg, kSerializer serializer, kAlloc allocator);

GvFx(kStatus) GvMeasureMsg_WriteDat6V1(GvMeasureMsg msg, kSerializer serializer);
GvFx(kStatus) GvMeasureMsg_ReadDat6V1(GvMeasureMsg msg, kSerializer serializer, kAlloc allocator);
GvFx(kStatus) GvMeasureMsg_ReadDat6V1Header(kSerializer serializer, kSize* count, kSize* extendedSize);
GvFx(kStatus) GvMeasureMsg_ReadDat6V1Content(GvMeasureMsg msg, kSerializer serializer, kSize frameIndex);

GvFx(kStatus) GvMeasureMsg_Allocate(GvMeasureMsg msg);

GvFx(kSize) GvMeasureMsg_DataSize(GvMeasureMsg msg);

GvFx(const kStamp*) GvMeasureMsg_StampAt(GvMeasureMsg msg, kSize index);
GvFx(kStatus) GvMeasureMsg_SetStampAt(GvMeasureMsg msg, kSize index, const kStamp* stamp);

GvFx(k64f) GvMeasureMsg_ValueAt(GvMeasureMsg msg, kSize index);
GvFx(kStatus) GvMeasureMsg_SetValueAt(GvMeasureMsg msg, kSize index, k64f value);

GvFx(k64f) GvMeasureMsg_UnfilteredValueAt(GvMeasureMsg msg, kSize index);
GvFx(kStatus) GvMeasureMsg_SetUnfilteredValueAt(GvMeasureMsg msg, kSize index, k64f value);

GvFx(k32s) GvMeasureMsg_StatusAt(GvMeasureMsg msg, kSize index);
GvFx(kStatus) GvMeasureMsg_SetStatusAt(GvMeasureMsg msg, kSize index, k32s status);

GvFx(void*) GvMeasureMsg_DataAt(GvMeasureMsg msg, kSize index);

GvFx(kStatus) GvMeasureMsg_SetObjectExtAt(GvMeasureMsg msg, kSize index, kObject object);
GvFx(kObject) GvMeasureMsg_ObjectExtAt(GvMeasureMsg msg, kSize index);

GvFx(kStatus) GvMeasureMsg_SetLabelPositionAt(GvMeasureMsg msg, kSize index, k64f x, k64f y, k64f z);
GvFx(const kPoint3d64f*) GvMeasureMsg_LabelPositionAt(GvMeasureMsg msg, kSize index);

#define GvMeasureMsg_StampAt_(M, I)                 GvxMeasureMsg_StampAt_(M, I)
#define GvMeasureMsg_ValueAt_(M, I)                 GvxMeasureMsg_ValueAt_(M, I)
#define GvMeasureMsg_UnfilteredValueAt_(M, I)       GvxMeasureMsg_UnfilteredValueAt_(M, I)
#define GvMeasureMsg_StatusAt_(M, I)                GvxMeasureMsg_StatusAt_(M, I)
#define GvMeasureMsg_DataAt_(M, I)                  GvxMeasureMsg_DataAt_(M, I)
#define GvMeasureMsg_ObjectExtAt_(M, I)             GvxMeasureMsg_ObjectExtAt_(M, I)
#define GvMeasureMsg_LabelPositionAt_(M, I)         GvxMeasureMsg_LabelPositionAt_(M, I)
#define GvMeasureMsg_RenderingAt_(M, I)             GvxMeasureMsg_RenderingAt_(M, I)

#define GvMeasureMsg_FrameAt_(M, I)                 ((GvMeasureMsgFrame*)((kByte*)xGvMeasureMsg_Cast(M)->buffer + xGvMeasureMsg_Cast(M)->frameSize * (I)))
#define GvxMeasureMsg_StampAt_(M, I)                (GvMeasureMsg_FrameAt_(M, I)->stamp)
#define GvxMeasureMsg_ValueAt_(M, I)                (GvMeasureMsg_FrameAt_(M, I)->value)
#define GvxMeasureMsg_UnfilteredValueAt_(M, I)      (GvMeasureMsg_FrameAt_(M, I)->unfilteredValue)
#define GvxMeasureMsg_StatusAt_(M, I)               (GvMeasureMsg_FrameAt_(M, I)->status)
#define GvxMeasureMsg_DataAt_(M, I)                 ((void*)((kByte*)GvMeasureMsg_FrameAt_(M, I) + sizeof(GvMeasureMsgFrame)))
#define GvxMeasureMsg_ObjectExtAt_(M, I)            (GvMeasureMsg_FrameAt_(M, I)->objectExtension)
#define GvxMeasureMsg_LabelPositionAt_(M, I)        (GvMeasureMsg_FrameAt_(M, I)->labelPosition)
#define GvxMeasureMsg_RenderingAt_(M, I)            (GvMeasureMsg_FrameAt_(M, I)->renderingObject)

#endif
